@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.GetFunctionUrlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFunctionUrl.
 * @property functionName The name (or ARN) of the Lambda function.
 * @property qualifier Alias name or `"$LATEST"`.
 */
public data class GetFunctionUrlPlainArgs(
    public val functionName: String,
    public val qualifier: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.GetFunctionUrlPlainArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.GetFunctionUrlPlainArgs =
        com.pulumi.aws.lambda.inputs.GetFunctionUrlPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .qualifier(qualifier?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFunctionUrlPlainArgs].
 */
@PulumiTagMarker
public class GetFunctionUrlPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var qualifier: String? = null

    /**
     * @param value The name (or ARN) of the Lambda function.
     */
    @JvmName("gxokiewgcxeohsgt")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value Alias name or `"$LATEST"`.
     */
    @JvmName("ydpjsymvieuvwepk")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.qualifier = mapped
    }

    internal fun build(): GetFunctionUrlPlainArgs = GetFunctionUrlPlainArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        qualifier = qualifier,
    )
}
