@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property collectionName The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
 * @property databaseName The name of the database to consume within the DocumentDB cluster.
 * @property fullDocument Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
 */
public data class EventSourceMappingDocumentDbEventSourceConfig(
    public val collectionName: String? = null,
    public val databaseName: String,
    public val fullDocument: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.EventSourceMappingDocumentDbEventSourceConfig):
            EventSourceMappingDocumentDbEventSourceConfig =
            EventSourceMappingDocumentDbEventSourceConfig(
                collectionName = javaType.collectionName().map({ args0 -> args0 }).orElse(null),
                databaseName = javaType.databaseName(),
                fullDocument = javaType.fullDocument().map({ args0 -> args0 }).orElse(null),
            )
    }
}
