@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property pattern A filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
 */
public data class EventSourceMappingFilterCriteriaFilter(
    public val pattern: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.EventSourceMappingFilterCriteriaFilter):
            EventSourceMappingFilterCriteriaFilter = EventSourceMappingFilterCriteriaFilter(
            pattern = javaType.pattern().map({ args0 -> args0 }).orElse(null),
        )
    }
}
