@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumConcurrency Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be between `2` and `1000`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
 */
public data class EventSourceMappingScalingConfig(
    public val maximumConcurrency: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.EventSourceMappingScalingConfig):
            EventSourceMappingScalingConfig = EventSourceMappingScalingConfig(
            maximumConcurrency = javaType.maximumConcurrency().map({ args0 -> args0 }).orElse(null),
        )
    }
}
