@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property consumerGroupId A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
 */
public data class EventSourceMappingSelfManagedKafkaEventSourceConfig(
    public val consumerGroupId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.EventSourceMappingSelfManagedKafkaEventSourceConfig):
            EventSourceMappingSelfManagedKafkaEventSourceConfig =
            EventSourceMappingSelfManagedKafkaEventSourceConfig(
                consumerGroupId = javaType.consumerGroupId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
