@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property variables Map of environment variables that are accessible from the function code during execution. If provided at least one key must be present.
 */
public data class FunctionEnvironment(
    public val variables: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionEnvironment):
            FunctionEnvironment = FunctionEnvironment(
            variables = javaType.variables().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
