@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
 * @property localMountPath Path where the function can access the file system, starting with /mnt/.
 */
public data class FunctionFileSystemConfig(
    public val arn: String,
    public val localMountPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionFileSystemConfig):
            FunctionFileSystemConfig = FunctionFileSystemConfig(
            arn = javaType.arn(),
            localMountPath = javaType.localMountPath(),
        )
    }
}
