@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commands Parameters that you want to pass in with `entry_point`.
 * @property entryPoints Entry point to your application, which is typically the location of the runtime executable.
 * @property workingDirectory Working directory.
 */
public data class FunctionImageConfig(
    public val commands: List<String>? = null,
    public val entryPoints: List<String>? = null,
    public val workingDirectory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionImageConfig):
            FunctionImageConfig = FunctionImageConfig(
            commands = javaType.commands().map({ args0 -> args0 }),
            entryPoints = javaType.entryPoints().map({ args0 -> args0 }),
            workingDirectory = javaType.workingDirectory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
