@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applyOn Conditions where snap start is enabled. Valid values are `PublishedVersions`.
 * @property optimizationStatus
 */
public data class FunctionSnapStart(
    public val applyOn: String,
    public val optimizationStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionSnapStart):
            FunctionSnapStart = FunctionSnapStart(
            applyOn = javaType.applyOn(),
            optimizationStatus = javaType.optimizationStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
