@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowCredentials Whether to allow cookies or other credentials in requests to the function URL. The default is `false`.
 * @property allowHeaders The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
 * @property allowMethods The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
 * @property allowOrigins The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www&#46;example&#46;com", "http://localhost:60905"]`.
 * @property exposeHeaders The HTTP headers in your function response that you want to expose to origins that call the function URL.
 * @property maxAge The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results. The maximum value is `86400`.
 */
public data class FunctionUrlCors(
    public val allowCredentials: Boolean? = null,
    public val allowHeaders: List<String>? = null,
    public val allowMethods: List<String>? = null,
    public val allowOrigins: List<String>? = null,
    public val exposeHeaders: List<String>? = null,
    public val maxAge: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionUrlCors): FunctionUrlCors =
            FunctionUrlCors(
                allowCredentials = javaType.allowCredentials().map({ args0 -> args0 }).orElse(null),
                allowHeaders = javaType.allowHeaders().map({ args0 -> args0 }),
                allowMethods = javaType.allowMethods().map({ args0 -> args0 }),
                allowOrigins = javaType.allowOrigins().map({ args0 -> args0 }),
                exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
                maxAge = javaType.maxAge().map({ args0 -> args0 }).orElse(null),
            )
    }
}
