@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCodeSigningConfig.
 * @property allowedPublishers List of allowed publishers as signing profiles for this code signing configuration.
 * @property arn
 * @property configId Unique identifier for the code signing configuration.
 * @property description Code signing configuration description.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastModified Date and time that the code signing configuration was last modified.
 * @property policies List of code signing policies that control the validation failure action for signature mismatch or expiry.
 */
public data class GetCodeSigningConfigResult(
    public val allowedPublishers: List<GetCodeSigningConfigAllowedPublisher>,
    public val arn: String,
    public val configId: String,
    public val description: String,
    public val id: String,
    public val lastModified: String,
    public val policies: List<GetCodeSigningConfigPolicy>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetCodeSigningConfigResult):
            GetCodeSigningConfigResult = GetCodeSigningConfigResult(
            allowedPublishers = javaType.allowedPublishers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.GetCodeSigningConfigAllowedPublisher.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            configId = javaType.configId(),
            description = javaType.description(),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.GetCodeSigningConfigPolicy.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
