@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn Unqualified (no `:QUALIFIER` or `:VERSION` suffix) ARN identifying your Lambda Function. See also `qualified_arn`.
 * @property localMountPath
 */
public data class GetFunctionFileSystemConfig(
    public val arn: String,
    public val localMountPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetFunctionFileSystemConfig):
            GetFunctionFileSystemConfig = GetFunctionFileSystemConfig(
            arn = javaType.arn(),
            localMountPath = javaType.localMountPath(),
        )
    }
}
