@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFunctions.
 * @property functionArns A list of Lambda Function ARNs.
 * @property functionNames A list of Lambda Function names.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetFunctionsResult(
    public val functionArns: List<String>,
    public val functionNames: List<String>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetFunctionsResult):
            GetFunctionsResult = GetFunctionsResult(
            functionArns = javaType.functionArns().map({ args0 -> args0 }),
            functionNames = javaType.functionNames().map({ args0 -> args0 }),
            id = javaType.id(),
        )
    }
}
