@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLayerVersion.
 * @property arn ARN of the Lambda Layer with version.
 * @property compatibleArchitecture
 * @property compatibleArchitectures A list of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersion.html#SSS-GetLayerVersion-response-CompatibleArchitectures) the specific Lambda Layer version is compatible with.
 * @property compatibleRuntime
 * @property compatibleRuntimes List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersion.html#SSS-GetLayerVersion-response-CompatibleRuntimes) the specific Lambda Layer version is compatible with.
 * @property createdDate Date this resource was created.
 * @property description Description of the specific Lambda Layer version.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property layerArn ARN of the Lambda Layer without version.
 * @property layerName
 * @property licenseInfo License info associated with the specific Lambda Layer version.
 * @property signingJobArn ARN of a signing job.
 * @property signingProfileVersionArn The ARN for a signing profile version.
 * @property sourceCodeHash Base64-encoded representation of raw SHA-256 sum of the zip file.
 * @property sourceCodeSize Size in bytes of the function .zip file.
 * @property version This Lamba Layer version.
 */
public data class GetLayerVersionResult(
    public val arn: String,
    public val compatibleArchitecture: String? = null,
    public val compatibleArchitectures: List<String>,
    public val compatibleRuntime: String? = null,
    public val compatibleRuntimes: List<String>,
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val layerArn: String,
    public val layerName: String,
    public val licenseInfo: String,
    public val signingJobArn: String,
    public val signingProfileVersionArn: String,
    public val sourceCodeHash: String,
    public val sourceCodeSize: Int,
    public val version: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetLayerVersionResult):
            GetLayerVersionResult = GetLayerVersionResult(
            arn = javaType.arn(),
            compatibleArchitecture = javaType.compatibleArchitecture().map({ args0 -> args0 }).orElse(null),
            compatibleArchitectures = javaType.compatibleArchitectures().map({ args0 -> args0 }),
            compatibleRuntime = javaType.compatibleRuntime().map({ args0 -> args0 }).orElse(null),
            compatibleRuntimes = javaType.compatibleRuntimes().map({ args0 -> args0 }),
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            id = javaType.id(),
            layerArn = javaType.layerArn(),
            layerName = javaType.layerName(),
            licenseInfo = javaType.licenseInfo(),
            signingJobArn = javaType.signingJobArn(),
            signingProfileVersionArn = javaType.signingProfileVersionArn(),
            sourceCodeHash = javaType.sourceCodeHash(),
            sourceCodeSize = javaType.sourceCodeSize(),
            version = javaType.version(),
        )
    }
}
