@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.aws.lb.LbFunctions.getHostedZoneIdPlain
import com.pulumi.aws.lb.LbFunctions.getLbsPlain
import com.pulumi.aws.lb.LbFunctions.getListenerPlain
import com.pulumi.aws.lb.LbFunctions.getLoadBalancerPlain
import com.pulumi.aws.lb.LbFunctions.getTargetGroupPlain
import com.pulumi.aws.lb.kotlin.inputs.GetHostedZoneIdPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetHostedZoneIdPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetLbsPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetLbsPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetListenerPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetListenerPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetLoadBalancerPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetLoadBalancerPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetTargetGroupPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetTargetGroupPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.outputs.GetHostedZoneIdResult
import com.pulumi.aws.lb.kotlin.outputs.GetLbsResult
import com.pulumi.aws.lb.kotlin.outputs.GetListenerResult
import com.pulumi.aws.lb.kotlin.outputs.GetLoadBalancerResult
import com.pulumi.aws.lb.kotlin.outputs.GetTargetGroupResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.lb.kotlin.outputs.GetHostedZoneIdResult.Companion.toKotlin as getHostedZoneIdResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetLbsResult.Companion.toKotlin as getLbsResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetListenerResult.Companion.toKotlin as getListenerResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetLoadBalancerResult.Companion.toKotlin as getLoadBalancerResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetTargetGroupResult.Companion.toKotlin as getTargetGroupResultToKotlin

public object LbFunctions {
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     *         var www = new Record("www", RecordArgs.builder()
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name("example.com")
     *             .type("A")
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_lb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -> getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getHostedZoneId.
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(argument: GetHostedZoneIdPlainArgs): GetHostedZoneIdResult =
        getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(argument.toJava()).await())

    /**
     * @see [getHostedZoneId].
     * @param loadBalancerType Type of load balancer to create. Possible values are `application` or `network`. The default value is `application`.
     * @param region Name of the region whose AWS ELB HostedZoneId is desired.
     * Defaults to the region from the AWS provider configuration.
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(loadBalancerType: String? = null, region: String? = null):
        GetHostedZoneIdResult {
        val argument = GetHostedZoneIdPlainArgs(
            loadBalancerType = loadBalancerType,
            region = region,
        )
        return getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostedZoneId].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetHostedZoneIdPlainArgs].
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(argument: suspend GetHostedZoneIdPlainArgsBuilder.() -> Unit):
        GetHostedZoneIdResult {
        val builder = GetHostedZoneIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of("elbv2.k8s.aws/cluster", "my-cluster"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLbs.
     * @return A collection of values returned by getLbs.
     */
    public suspend fun getLbs(argument: GetLbsPlainArgs): GetLbsResult =
        getLbsResultToKotlin(getLbsPlain(argument.toJava()).await())

    /**
     * @see [getLbs].
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired Load Balancers.
     * @return A collection of values returned by getLbs.
     */
    public suspend fun getLbs(tags: Map<String, String>? = null): GetLbsResult {
        val argument = GetLbsPlainArgs(
            tags = tags,
        )
        return getLbsResultToKotlin(getLbsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLbs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetLbsPlainArgs].
     * @return A collection of values returned by getLbs.
     */
    public suspend fun getLbs(argument: suspend GetLbsPlainArgsBuilder.() -> Unit): GetLbsResult {
        val builder = GetLbsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLbsResultToKotlin(getLbsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * Provides information about a Load Balancer Listener.
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get("listenerArn");
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name("default-public")
     *             .build());
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -> getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getListener.
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: GetListenerPlainArgs): GetListenerResult =
        getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())

    /**
     * @see [getListener].
     * @param arn ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
     * @param loadBalancerArn ARN of the load balancer. Required if `arn` is not set.
     * @param port Port of the listener. Required if `arn` is not set.
     * @param tags
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(
        arn: String? = null,
        loadBalancerArn: String? = null,
        port: Int? = null,
        tags: Map<String, String>? = null,
    ): GetListenerResult {
        val argument = GetListenerPlainArgs(
            arn = arn,
            loadBalancerArn = loadBalancerArn,
            port = port,
            tags = tags,
        )
        return getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())
    }

    /**
     * @see [getListener].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetListenerPlainArgs].
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: suspend GetListenerPlainArgsBuilder.() -> Unit):
        GetListenerResult {
        val builder = GetListenerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenerResultToKotlin(getListenerPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * Provides information about a Load Balancer.
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get("lbArn").orElse("");
     *         final var lbName = config.get("lbName").orElse("");
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLoadBalancer.
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: GetLoadBalancerPlainArgs): GetLoadBalancerResult =
        getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())

    /**
     * @see [getLoadBalancer].
     * @param arn Full ARN of the load balancer.
     * @param name Unique name of the load balancer.
     * @param tags Mapping of tags, each pair of which must exactly match a pair on the desired load balancer.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has lowest precedence.
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetLoadBalancerResult {
        val argument = GetLoadBalancerPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadBalancer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetLoadBalancerPlainArgs].
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: suspend GetLoadBalancerPlainArgsBuilder.() -> Unit):
        GetLoadBalancerResult {
        val builder = GetLoadBalancerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * Provides information about a Load Balancer Target Group.
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get("lbTgArn").orElse("");
     *         final var lbTgName = config.get("lbTgName").orElse("");
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTargetGroup.
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(argument: GetTargetGroupPlainArgs): GetTargetGroupResult =
        getTargetGroupResultToKotlin(getTargetGroupPlain(argument.toJava()).await())

    /**
     * @see [getTargetGroup].
     * @param arn Full ARN of the target group.
     * @param name Unique name of the target group.
     * @param tags Mapping of tags, each pair of which must exactly match a pair on the desired target group.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has the lowest precedence.
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetTargetGroupResult {
        val argument = GetTargetGroupPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getTargetGroupResultToKotlin(getTargetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getTargetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetTargetGroupPlainArgs].
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(argument: suspend GetTargetGroupPlainArgsBuilder.() -> Unit):
        GetTargetGroupResult {
        val builder = GetTargetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTargetGroupResultToKotlin(getTargetGroupPlain(builtArgument.toJava()).await())
    }
}
