@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ListenerCertificate].
 */
@PulumiTagMarker
public class ListenerCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerCertificateArgs = ListenerCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerCertificateArgsBuilder.() -> Unit) {
        val builder = ListenerCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ListenerCertificate {
        val builtJavaResource = com.pulumi.aws.lb.ListenerCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ListenerCertificate(builtJavaResource)
    }
}

/**
 * Provides a Load Balancer Listener Certificate resource.
 * This resource is for additional certificates and does not replace the default certificate on the listener.
 * > **Note:** `aws.alb.ListenerCertificate` is known as `aws.lb.ListenerCertificate`. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acm.Certificate;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerCertificate;
 * import com.pulumi.aws.lb.ListenerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificate = new Certificate("exampleCertificate");
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndListener = new Listener("frontEndListener");
 *         var exampleListenerCertificate = new ListenerCertificate("exampleListenerCertificate", ListenerCertificateArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .certificateArn(exampleCertificate.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Listener Certificates using the listener arn and certificate arn, separated by an underscore (`_`). For example:
 * ```sh
 *  $ pulumi import aws:lb/listenerCertificate:ListenerCertificate example arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/test/8e4497da625e2d8a/9ab28ade35828f96/67b3d2d36dd7c26b_arn:aws:iam::123456789012:server-certificate/tf-acc-test-6453083910015726063
 * ```
 *
 */
public class ListenerCertificate internal constructor(
    override val javaResource: com.pulumi.aws.lb.ListenerCertificate,
) : KotlinCustomResource(javaResource, ListenerCertificateMapper) {
    /**
     * The ARN of the certificate to attach to the listener.
     */
    public val certificateArn: Output<String>
        get() = javaResource.certificateArn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the listener to which to attach the certificate.
     */
    public val listenerArn: Output<String>
        get() = javaResource.listenerArn().applyValue({ args0 -> args0 })
}

public object ListenerCertificateMapper : ResourceMapper<ListenerCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lb.ListenerCertificate::class == javaResource::class

    override fun map(javaResource: Resource): ListenerCertificate = ListenerCertificate(
        javaResource
            as com.pulumi.aws.lb.ListenerCertificate,
    )
}

/**
 * @see [ListenerCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerCertificate].
 */
public suspend fun listenerCertificate(
    name: String,
    block: suspend ListenerCertificateResourceBuilder.() -> Unit,
): ListenerCertificate {
    val builder = ListenerCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerCertificate(name: String): ListenerCertificate {
    val builder = ListenerCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
