@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.aws.lb.LoadBalancerArgs.builder
import com.pulumi.aws.lb.kotlin.inputs.LoadBalancerAccessLogsArgs
import com.pulumi.aws.lb.kotlin.inputs.LoadBalancerAccessLogsArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.LoadBalancerSubnetMappingArgs
import com.pulumi.aws.lb.kotlin.inputs.LoadBalancerSubnetMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Load Balancer resource.
 * > **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
 * ## Example Usage
 * ### Application Load Balancer
 * No Java example available.
 * ### Network Load Balancer
 * No Java example available.
 * ### Specifying Elastic IPs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoadBalancer("example", LoadBalancerArgs.builder()
 *             .loadBalancerType("network")
 *             .subnetMappings(
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(aws_subnet.example1().id())
 *                     .allocationId(aws_eip.example1().id())
 *                     .build(),
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(aws_subnet.example2().id())
 *                     .allocationId(aws_eip.example2().id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying private IP addresses for an internal-facing load balancer
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoadBalancer("example", LoadBalancerArgs.builder()
 *             .loadBalancerType("network")
 *             .subnetMappings(
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(aws_subnet.example1().id())
 *                     .privateIpv4Address("10.0.1.15")
 *                     .build(),
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(aws_subnet.example2().id())
 *                     .privateIpv4Address("10.0.2.15")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import LBs using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:lb/loadBalancer:LoadBalancer bar arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188
 * ```
 * @property accessLogs An Access Logs block. Access Logs documented below.
 * @property customerOwnedIpv4Pool The ID of the customer owned ipv4 pool to use for this load balancer.
 * @property desyncMitigationMode Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
 * @property dnsRecordClientRoutingPolicy Indicates how traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
 * @property dropInvalidHeaderFields Indicates whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
 * @property enableCrossZoneLoadBalancing If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
 * @property enableDeletionProtection If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
 * @property enableHttp2 Indicates whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
 * @property enableTlsVersionAndCipherSuiteHeaders Indicates whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
 * @property enableWafFailOpen Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
 * @property enableXffClientPort Indicates whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
 * @property idleTimeout The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
 * @property internal If true, the LB will be internal. Defaults to `false`.
 * @property ipAddressType The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` and `dualstack`.
 * @property loadBalancerType The type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
 * @property name The name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters,
 * must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified,
 * this provider will autogenerate a name beginning with `tf-lb`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property preserveHostHeader Indicates whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
 * @property securityGroups A list of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
 * @property subnetMappings A subnet mapping block as documented below.
 * @property subnets A list of subnet IDs to attach to the LB. Subnets
 * cannot be updated for Load Balancers of type `network`. Changing this value
 * for load balancers of type `network` will force a recreation of the resource.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property xffHeaderProcessingMode Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
 */
public data class LoadBalancerArgs(
    public val accessLogs: Output<LoadBalancerAccessLogsArgs>? = null,
    public val customerOwnedIpv4Pool: Output<String>? = null,
    public val desyncMitigationMode: Output<String>? = null,
    public val dnsRecordClientRoutingPolicy: Output<String>? = null,
    public val dropInvalidHeaderFields: Output<Boolean>? = null,
    public val enableCrossZoneLoadBalancing: Output<Boolean>? = null,
    public val enableDeletionProtection: Output<Boolean>? = null,
    public val enableHttp2: Output<Boolean>? = null,
    public val enableTlsVersionAndCipherSuiteHeaders: Output<Boolean>? = null,
    public val enableWafFailOpen: Output<Boolean>? = null,
    public val enableXffClientPort: Output<Boolean>? = null,
    public val idleTimeout: Output<Int>? = null,
    public val `internal`: Output<Boolean>? = null,
    public val ipAddressType: Output<String>? = null,
    public val loadBalancerType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val preserveHostHeader: Output<Boolean>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnetMappings: Output<List<LoadBalancerSubnetMappingArgs>>? = null,
    public val subnets: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val xffHeaderProcessingMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.aws.lb.LoadBalancerArgs =
        com.pulumi.aws.lb.LoadBalancerArgs.builder()
            .accessLogs(accessLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customerOwnedIpv4Pool(customerOwnedIpv4Pool?.applyValue({ args0 -> args0 }))
            .desyncMitigationMode(desyncMitigationMode?.applyValue({ args0 -> args0 }))
            .dnsRecordClientRoutingPolicy(dnsRecordClientRoutingPolicy?.applyValue({ args0 -> args0 }))
            .dropInvalidHeaderFields(dropInvalidHeaderFields?.applyValue({ args0 -> args0 }))
            .enableCrossZoneLoadBalancing(enableCrossZoneLoadBalancing?.applyValue({ args0 -> args0 }))
            .enableDeletionProtection(enableDeletionProtection?.applyValue({ args0 -> args0 }))
            .enableHttp2(enableHttp2?.applyValue({ args0 -> args0 }))
            .enableTlsVersionAndCipherSuiteHeaders(
                enableTlsVersionAndCipherSuiteHeaders?.applyValue({ args0 ->
                    args0
                }),
            )
            .enableWafFailOpen(enableWafFailOpen?.applyValue({ args0 -> args0 }))
            .enableXffClientPort(enableXffClientPort?.applyValue({ args0 -> args0 }))
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 }))
            .`internal`(`internal`?.applyValue({ args0 -> args0 }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .loadBalancerType(loadBalancerType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .preserveHostHeader(preserveHostHeader?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetMappings(
                subnetMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnets(subnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .xffHeaderProcessingMode(xffHeaderProcessingMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var accessLogs: Output<LoadBalancerAccessLogsArgs>? = null

    private var customerOwnedIpv4Pool: Output<String>? = null

    private var desyncMitigationMode: Output<String>? = null

    private var dnsRecordClientRoutingPolicy: Output<String>? = null

    private var dropInvalidHeaderFields: Output<Boolean>? = null

    private var enableCrossZoneLoadBalancing: Output<Boolean>? = null

    private var enableDeletionProtection: Output<Boolean>? = null

    private var enableHttp2: Output<Boolean>? = null

    private var enableTlsVersionAndCipherSuiteHeaders: Output<Boolean>? = null

    private var enableWafFailOpen: Output<Boolean>? = null

    private var enableXffClientPort: Output<Boolean>? = null

    private var idleTimeout: Output<Int>? = null

    private var `internal`: Output<Boolean>? = null

    private var ipAddressType: Output<String>? = null

    private var loadBalancerType: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var preserveHostHeader: Output<Boolean>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnetMappings: Output<List<LoadBalancerSubnetMappingArgs>>? = null

    private var subnets: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var xffHeaderProcessingMode: Output<String>? = null

    /**
     * @param value An Access Logs block. Access Logs documented below.
     */
    @JvmName("sgvttvlhkkexujbq")
    public suspend fun accessLogs(`value`: Output<LoadBalancerAccessLogsArgs>) {
        this.accessLogs = value
    }

    /**
     * @param value The ID of the customer owned ipv4 pool to use for this load balancer.
     */
    @JvmName("oxvfcagjswgnumgl")
    public suspend fun customerOwnedIpv4Pool(`value`: Output<String>) {
        this.customerOwnedIpv4Pool = value
    }

    /**
     * @param value Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    @JvmName("xpvrobghjhucnovi")
    public suspend fun desyncMitigationMode(`value`: Output<String>) {
        this.desyncMitigationMode = value
    }

    /**
     * @param value Indicates how traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
     */
    @JvmName("dmudubafcynrtmud")
    public suspend fun dnsRecordClientRoutingPolicy(`value`: Output<String>) {
        this.dnsRecordClientRoutingPolicy = value
    }

    /**
     * @param value Indicates whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
     */
    @JvmName("fypxtuvdtdtctqeu")
    public suspend fun dropInvalidHeaderFields(`value`: Output<Boolean>) {
        this.dropInvalidHeaderFields = value
    }

    /**
     * @param value If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
     */
    @JvmName("umbqcitslsktcfpu")
    public suspend fun enableCrossZoneLoadBalancing(`value`: Output<Boolean>) {
        this.enableCrossZoneLoadBalancing = value
    }

    /**
     * @param value If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
     */
    @JvmName("cqqwixckytimayem")
    public suspend fun enableDeletionProtection(`value`: Output<Boolean>) {
        this.enableDeletionProtection = value
    }

    /**
     * @param value Indicates whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
     */
    @JvmName("wqpkrcvpxxpeomok")
    public suspend fun enableHttp2(`value`: Output<Boolean>) {
        this.enableHttp2 = value
    }

    /**
     * @param value Indicates whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
     */
    @JvmName("hlwompnfsnscdxjm")
    public suspend fun enableTlsVersionAndCipherSuiteHeaders(`value`: Output<Boolean>) {
        this.enableTlsVersionAndCipherSuiteHeaders = value
    }

    /**
     * @param value Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
     */
    @JvmName("nvwlpetxmlqefhlw")
    public suspend fun enableWafFailOpen(`value`: Output<Boolean>) {
        this.enableWafFailOpen = value
    }

    /**
     * @param value Indicates whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
     */
    @JvmName("dywhvmumsvrckcnx")
    public suspend fun enableXffClientPort(`value`: Output<Boolean>) {
        this.enableXffClientPort = value
    }

    /**
     * @param value The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
     */
    @JvmName("mrpefhkbjkfsusff")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value If true, the LB will be internal. Defaults to `false`.
     */
    @JvmName("rxaxfxhhjcuffgms")
    public suspend fun `internal`(`value`: Output<Boolean>) {
        this.`internal` = value
    }

    /**
     * @param value The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` and `dualstack`.
     */
    @JvmName("nutejqbpjbiqbamf")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
     */
    @JvmName("ybwnqewfunmppihh")
    public suspend fun loadBalancerType(`value`: Output<String>) {
        this.loadBalancerType = value
    }

    /**
     * @param value The name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters,
     * must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified,
     * this provider will autogenerate a name beginning with `tf-lb`.
     */
    @JvmName("hfekdgksbsrewidx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("entqxklwrgqiskto")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Indicates whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
     */
    @JvmName("aoqyncrybwctjfhi")
    public suspend fun preserveHostHeader(`value`: Output<Boolean>) {
        this.preserveHostHeader = value
    }

    /**
     * @param value A list of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
     */
    @JvmName("bfasbxbdjfqaghpi")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("himxusmdyiwujsge")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
     */
    @JvmName("ywppufvivqpxntqf")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value A subnet mapping block as documented below.
     */
    @JvmName("qbievbfejrgvehwm")
    public suspend fun subnetMappings(`value`: Output<List<LoadBalancerSubnetMappingArgs>>) {
        this.subnetMappings = value
    }

    @JvmName("brlukuwwviobaxyh")
    public suspend fun subnetMappings(vararg values: Output<LoadBalancerSubnetMappingArgs>) {
        this.subnetMappings = Output.all(values.asList())
    }

    /**
     * @param values A subnet mapping block as documented below.
     */
    @JvmName("yxlurfoxqxigxpnl")
    public suspend fun subnetMappings(values: List<Output<LoadBalancerSubnetMappingArgs>>) {
        this.subnetMappings = Output.all(values)
    }

    /**
     * @param value A list of subnet IDs to attach to the LB. Subnets
     * cannot be updated for Load Balancers of type `network`. Changing this value
     * for load balancers of type `network` will force a recreation of the resource.
     */
    @JvmName("avpmgtgrgcctxkmx")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("ghbxdafiefspouny")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs to attach to the LB. Subnets
     * cannot be updated for Load Balancers of type `network`. Changing this value
     * for load balancers of type `network` will force a recreation of the resource.
     */
    @JvmName("equxyfwhjmlxpyta")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vxeutoibkvekfohs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
     */
    @JvmName("fwoikihwwnveuevt")
    public suspend fun xffHeaderProcessingMode(`value`: Output<String>) {
        this.xffHeaderProcessingMode = value
    }

    /**
     * @param value An Access Logs block. Access Logs documented below.
     */
    @JvmName("tyvkpmgmqsqejrse")
    public suspend fun accessLogs(`value`: LoadBalancerAccessLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogs = mapped
    }

    /**
     * @param argument An Access Logs block. Access Logs documented below.
     */
    @JvmName("mldbvrtbwoiuoopb")
    public suspend fun accessLogs(argument: suspend LoadBalancerAccessLogsArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerAccessLogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogs = mapped
    }

    /**
     * @param value The ID of the customer owned ipv4 pool to use for this load balancer.
     */
    @JvmName("xpgddabjimivwthv")
    public suspend fun customerOwnedIpv4Pool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerOwnedIpv4Pool = mapped
    }

    /**
     * @param value Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    @JvmName("yjbfyourqvirfuli")
    public suspend fun desyncMitigationMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desyncMitigationMode = mapped
    }

    /**
     * @param value Indicates how traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
     */
    @JvmName("vvqxqjtiqcdirgps")
    public suspend fun dnsRecordClientRoutingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsRecordClientRoutingPolicy = mapped
    }

    /**
     * @param value Indicates whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
     */
    @JvmName("xixmkpqvccxulehr")
    public suspend fun dropInvalidHeaderFields(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dropInvalidHeaderFields = mapped
    }

    /**
     * @param value If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
     */
    @JvmName("xwfwdxgqrhpcnhdu")
    public suspend fun enableCrossZoneLoadBalancing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCrossZoneLoadBalancing = mapped
    }

    /**
     * @param value If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
     */
    @JvmName("wknasqjtskdioyls")
    public suspend fun enableDeletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDeletionProtection = mapped
    }

    /**
     * @param value Indicates whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
     */
    @JvmName("ughjtjewewvhjwrh")
    public suspend fun enableHttp2(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHttp2 = mapped
    }

    /**
     * @param value Indicates whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
     */
    @JvmName("uigyqlumcbhxqika")
    public suspend fun enableTlsVersionAndCipherSuiteHeaders(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTlsVersionAndCipherSuiteHeaders = mapped
    }

    /**
     * @param value Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
     */
    @JvmName("uorweghkxqnbdatp")
    public suspend fun enableWafFailOpen(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableWafFailOpen = mapped
    }

    /**
     * @param value Indicates whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
     */
    @JvmName("xhmntmnovggxpfaw")
    public suspend fun enableXffClientPort(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableXffClientPort = mapped
    }

    /**
     * @param value The time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
     */
    @JvmName("ntdeqooxgqwdykkn")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    /**
     * @param value If true, the LB will be internal. Defaults to `false`.
     */
    @JvmName("lyisievouhdfkinv")
    public suspend fun `internal`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`internal` = mapped
    }

    /**
     * @param value The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` and `dualstack`.
     */
    @JvmName("ftacdpohtjkqwngv")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
     */
    @JvmName("avveisdvkaddpvep")
    public suspend fun loadBalancerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value The name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters,
     * must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified,
     * this provider will autogenerate a name beginning with `tf-lb`.
     */
    @JvmName("urhvnmodbkxcohum")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("pofoniaadyqoqcoc")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Indicates whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
     */
    @JvmName("bwbsblbccgklirgj")
    public suspend fun preserveHostHeader(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveHostHeader = mapped
    }

    /**
     * @param value A list of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
     */
    @JvmName("gvkiymbshtwnsiyf")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
     */
    @JvmName("yulqrgeqvyblsxap")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value A subnet mapping block as documented below.
     */
    @JvmName("aegmpqlsomaofbko")
    public suspend fun subnetMappings(`value`: List<LoadBalancerSubnetMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetMappings = mapped
    }

    /**
     * @param argument A subnet mapping block as documented below.
     */
    @JvmName("gccjmxpqbiodwxlx")
    public suspend
    fun subnetMappings(argument: List<suspend LoadBalancerSubnetMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerSubnetMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetMappings = mapped
    }

    /**
     * @param argument A subnet mapping block as documented below.
     */
    @JvmName("bawgjwutypuohaes")
    public suspend fun subnetMappings(
        vararg
        argument: suspend LoadBalancerSubnetMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerSubnetMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetMappings = mapped
    }

    /**
     * @param argument A subnet mapping block as documented below.
     */
    @JvmName("mpdlqnxbnmehbehh")
    public suspend
    fun subnetMappings(argument: suspend LoadBalancerSubnetMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerSubnetMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subnetMappings = mapped
    }

    /**
     * @param values A subnet mapping block as documented below.
     */
    @JvmName("lljeywllvvdbhfto")
    public suspend fun subnetMappings(vararg values: LoadBalancerSubnetMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetMappings = mapped
    }

    /**
     * @param value A list of subnet IDs to attach to the LB. Subnets
     * cannot be updated for Load Balancers of type `network`. Changing this value
     * for load balancers of type `network` will force a recreation of the resource.
     */
    @JvmName("uyxvboeqarfidkqv")
    public suspend fun subnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values A list of subnet IDs to attach to the LB. Subnets
     * cannot be updated for Load Balancers of type `network`. Changing this value
     * for load balancers of type `network` will force a recreation of the resource.
     */
    @JvmName("kcjvfxbbapkndoom")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgjjdoenpwecryjt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iyrhrbosechybxjk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
     */
    @JvmName("upclwrbsnsqyhgdo")
    public suspend fun xffHeaderProcessingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xffHeaderProcessingMode = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        accessLogs = accessLogs,
        customerOwnedIpv4Pool = customerOwnedIpv4Pool,
        desyncMitigationMode = desyncMitigationMode,
        dnsRecordClientRoutingPolicy = dnsRecordClientRoutingPolicy,
        dropInvalidHeaderFields = dropInvalidHeaderFields,
        enableCrossZoneLoadBalancing = enableCrossZoneLoadBalancing,
        enableDeletionProtection = enableDeletionProtection,
        enableHttp2 = enableHttp2,
        enableTlsVersionAndCipherSuiteHeaders = enableTlsVersionAndCipherSuiteHeaders,
        enableWafFailOpen = enableWafFailOpen,
        enableXffClientPort = enableXffClientPort,
        idleTimeout = idleTimeout,
        `internal` = `internal`,
        ipAddressType = ipAddressType,
        loadBalancerType = loadBalancerType,
        name = name,
        namePrefix = namePrefix,
        preserveHostHeader = preserveHostHeader,
        securityGroups = securityGroups,
        subnetMappings = subnetMappings,
        subnets = subnets,
        tags = tags,
        xffHeaderProcessingMode = xffHeaderProcessingMode,
    )
}
