@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.aws.lb.TargetGroupArgs.builder
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupHealthCheckArgs
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupHealthCheckArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupStickinessArgs
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupStickinessArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupTargetFailoverArgs
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupTargetFailoverArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupTargetHealthStateArgs
import com.pulumi.aws.lb.kotlin.inputs.TargetGroupTargetHealthStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Target Group resource for use with Load Balancer resources.
 * > **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
 * ## Example Usage
 * ### Instance Target Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var test = new TargetGroup("test", TargetGroupArgs.builder()
 *             .port(80)
 *             .protocol("HTTP")
 *             .vpcId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ### IP Target Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var ip_example = new TargetGroup("ip-example", TargetGroupArgs.builder()
 *             .port(80)
 *             .protocol("HTTP")
 *             .targetType("ip")
 *             .vpcId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Target Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lambda_example = new TargetGroup("lambda-example", TargetGroupArgs.builder()
 *             .targetType("lambda")
 *             .build());
 *     }
 * }
 * ```
 * ### ALB Target Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alb_example = new TargetGroup("alb-example", TargetGroupArgs.builder()
 *             .targetType("alb")
 *             .port(80)
 *             .protocol("TCP")
 *             .vpcId(aws_vpc.main().id())
 *             .build());
 *     }
 * }
 * ```
 * ### Target group with unhealthy connection termination disabled
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tcp_example = new TargetGroup("tcp-example", TargetGroupArgs.builder()
 *             .port(25)
 *             .protocol("TCP")
 *             .vpcId(aws_vpc.main().id())
 *             .targetHealthStates(TargetGroupTargetHealthStateArgs.builder()
 *                 .enableUnhealthyConnectionTermination(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Target Groups using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:lb/targetGroup:TargetGroup app_front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:targetgroup/app-front-end/20cfe21448b66314
 * ```
 * @property connectionTermination Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
 * @property deregistrationDelay Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
 * @property healthCheck Health Check configuration block. Detailed below.
 * @property ipAddressType The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
 * @property lambdaMultiValueHeadersEnabled Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
 * @property loadBalancingAlgorithmType Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin` or `least_outstanding_requests`. The default is `round_robin`.
 * @property loadBalancingCrossZoneEnabled Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
 * @property name Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
 * @property port Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
 * @property preserveClientIp Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
 * @property protocol Protocol to use for routing traffic to the targets.
 * Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
 * Required when `target_type` is `instance`, `ip`, or `alb`.
 * Does not apply when `target_type` is `lambda`.
 * @property protocolVersion Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
 * @property proxyProtocolV2 Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
 * @property slowStart Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
 * @property stickiness Stickiness configuration block. Detailed below.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetFailovers Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
 * @property targetHealthStates Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
 * @property targetType Type of target that you must specify when registering targets with this target group.
 * See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
 * The default is `instance`.
 * Note that you can't specify targets for a target group using both instance IDs and IP addresses.
 * If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
 * Network Load Balancers do not support the `lambda` target type.
 * Application Load Balancers do not support the `alb` target type.
 * @property vpcId Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
 */
public data class TargetGroupArgs(
    public val connectionTermination: Output<Boolean>? = null,
    public val deregistrationDelay: Output<Int>? = null,
    public val healthCheck: Output<TargetGroupHealthCheckArgs>? = null,
    public val ipAddressType: Output<String>? = null,
    public val lambdaMultiValueHeadersEnabled: Output<Boolean>? = null,
    public val loadBalancingAlgorithmType: Output<String>? = null,
    public val loadBalancingCrossZoneEnabled: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val preserveClientIp: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val protocolVersion: Output<String>? = null,
    public val proxyProtocolV2: Output<Boolean>? = null,
    public val slowStart: Output<Int>? = null,
    public val stickiness: Output<TargetGroupStickinessArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetFailovers: Output<List<TargetGroupTargetFailoverArgs>>? = null,
    public val targetHealthStates: Output<List<TargetGroupTargetHealthStateArgs>>? = null,
    public val targetType: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.TargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.lb.TargetGroupArgs =
        com.pulumi.aws.lb.TargetGroupArgs.builder()
            .connectionTermination(connectionTermination?.applyValue({ args0 -> args0 }))
            .deregistrationDelay(deregistrationDelay?.applyValue({ args0 -> args0 }))
            .healthCheck(healthCheck?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .lambdaMultiValueHeadersEnabled(lambdaMultiValueHeadersEnabled?.applyValue({ args0 -> args0 }))
            .loadBalancingAlgorithmType(loadBalancingAlgorithmType?.applyValue({ args0 -> args0 }))
            .loadBalancingCrossZoneEnabled(loadBalancingCrossZoneEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .preserveClientIp(preserveClientIp?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .protocolVersion(protocolVersion?.applyValue({ args0 -> args0 }))
            .proxyProtocolV2(proxyProtocolV2?.applyValue({ args0 -> args0 }))
            .slowStart(slowStart?.applyValue({ args0 -> args0 }))
            .stickiness(stickiness?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetFailovers(
                targetFailovers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetHealthStates(
                targetHealthStates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetType(targetType?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupArgs].
 */
@PulumiTagMarker
public class TargetGroupArgsBuilder internal constructor() {
    private var connectionTermination: Output<Boolean>? = null

    private var deregistrationDelay: Output<Int>? = null

    private var healthCheck: Output<TargetGroupHealthCheckArgs>? = null

    private var ipAddressType: Output<String>? = null

    private var lambdaMultiValueHeadersEnabled: Output<Boolean>? = null

    private var loadBalancingAlgorithmType: Output<String>? = null

    private var loadBalancingCrossZoneEnabled: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var port: Output<Int>? = null

    private var preserveClientIp: Output<String>? = null

    private var protocol: Output<String>? = null

    private var protocolVersion: Output<String>? = null

    private var proxyProtocolV2: Output<Boolean>? = null

    private var slowStart: Output<Int>? = null

    private var stickiness: Output<TargetGroupStickinessArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetFailovers: Output<List<TargetGroupTargetFailoverArgs>>? = null

    private var targetHealthStates: Output<List<TargetGroupTargetHealthStateArgs>>? = null

    private var targetType: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
     */
    @JvmName("ckhbkxfxmpwluipl")
    public suspend fun connectionTermination(`value`: Output<Boolean>) {
        this.connectionTermination = value
    }

    /**
     * @param value Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
     */
    @JvmName("wreqryligygruwvk")
    public suspend fun deregistrationDelay(`value`: Output<Int>) {
        this.deregistrationDelay = value
    }

    /**
     * @param value Health Check configuration block. Detailed below.
     */
    @JvmName("cdpqtxsypsgvvsov")
    public suspend fun healthCheck(`value`: Output<TargetGroupHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
     */
    @JvmName("livnecwcyfpwxblq")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
     */
    @JvmName("nahocldkoknngngm")
    public suspend fun lambdaMultiValueHeadersEnabled(`value`: Output<Boolean>) {
        this.lambdaMultiValueHeadersEnabled = value
    }

    /**
     * @param value Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin` or `least_outstanding_requests`. The default is `round_robin`.
     */
    @JvmName("gxgkiwwshfxsumkn")
    public suspend fun loadBalancingAlgorithmType(`value`: Output<String>) {
        this.loadBalancingAlgorithmType = value
    }

    /**
     * @param value Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
     */
    @JvmName("mawnhuesrtywqflt")
    public suspend fun loadBalancingCrossZoneEnabled(`value`: Output<String>) {
        this.loadBalancingCrossZoneEnabled = value
    }

    /**
     * @param value Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    @JvmName("jbuviikalkcmcklc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
     */
    @JvmName("reiaapowgdpbulsa")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
     */
    @JvmName("blgbktarwwirejku")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
     */
    @JvmName("qewxktghvdertweo")
    public suspend fun preserveClientIp(`value`: Output<String>) {
        this.preserveClientIp = value
    }

    /**
     * @param value Protocol to use for routing traffic to the targets.
     * Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
     * Required when `target_type` is `instance`, `ip`, or `alb`.
     * Does not apply when `target_type` is `lambda`.
     */
    @JvmName("pvpbfvvbrpnyuakp")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
     */
    @JvmName("ooghqdwxnsyljnbo")
    public suspend fun protocolVersion(`value`: Output<String>) {
        this.protocolVersion = value
    }

    /**
     * @param value Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
     */
    @JvmName("bibebnbuiqkvtmya")
    public suspend fun proxyProtocolV2(`value`: Output<Boolean>) {
        this.proxyProtocolV2 = value
    }

    /**
     * @param value Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
     */
    @JvmName("sipxaenlqangkypp")
    public suspend fun slowStart(`value`: Output<Int>) {
        this.slowStart = value
    }

    /**
     * @param value Stickiness configuration block. Detailed below.
     */
    @JvmName("hdxqxfyqxtgrfnkm")
    public suspend fun stickiness(`value`: Output<TargetGroupStickinessArgs>) {
        this.stickiness = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("daboslcphlddabsy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    @JvmName("fwsjlwjbbwreyphg")
    public suspend fun targetFailovers(`value`: Output<List<TargetGroupTargetFailoverArgs>>) {
        this.targetFailovers = value
    }

    @JvmName("dbnsmorksgpqnffd")
    public suspend fun targetFailovers(vararg values: Output<TargetGroupTargetFailoverArgs>) {
        this.targetFailovers = Output.all(values.asList())
    }

    /**
     * @param values Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    @JvmName("frqksccvuawwwwnn")
    public suspend fun targetFailovers(values: List<Output<TargetGroupTargetFailoverArgs>>) {
        this.targetFailovers = Output.all(values)
    }

    /**
     * @param value Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    @JvmName("hmsfcfmicjmdmpbv")
    public suspend fun targetHealthStates(`value`: Output<List<TargetGroupTargetHealthStateArgs>>) {
        this.targetHealthStates = value
    }

    @JvmName("wycjmfpdqouauxsx")
    public suspend fun targetHealthStates(vararg values: Output<TargetGroupTargetHealthStateArgs>) {
        this.targetHealthStates = Output.all(values.asList())
    }

    /**
     * @param values Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    @JvmName("nwasllpqedwdtihp")
    public suspend fun targetHealthStates(values: List<Output<TargetGroupTargetHealthStateArgs>>) {
        this.targetHealthStates = Output.all(values)
    }

    /**
     * @param value Type of target that you must specify when registering targets with this target group.
     * See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
     * The default is `instance`.
     * Note that you can't specify targets for a target group using both instance IDs and IP addresses.
     * If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
     * Network Load Balancers do not support the `lambda` target type.
     * Application Load Balancers do not support the `alb` target type.
     */
    @JvmName("sjyrqbvldladfwkj")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
     */
    @JvmName("jrpxqxdoddytlrfl")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
     */
    @JvmName("xbgcacevteynixtu")
    public suspend fun connectionTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTermination = mapped
    }

    /**
     * @param value Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
     */
    @JvmName("nhndfrhxjaejlvrr")
    public suspend fun deregistrationDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deregistrationDelay = mapped
    }

    /**
     * @param value Health Check configuration block. Detailed below.
     */
    @JvmName("vgkylrmlpltkndyt")
    public suspend fun healthCheck(`value`: TargetGroupHealthCheckArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument Health Check configuration block. Detailed below.
     */
    @JvmName("vwljxoqlxeffynls")
    public suspend fun healthCheck(argument: suspend TargetGroupHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupHealthCheckArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    /**
     * @param value The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
     */
    @JvmName("yjfnqnltmhcywatv")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
     */
    @JvmName("hrefoqkaewkmlogj")
    public suspend fun lambdaMultiValueHeadersEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaMultiValueHeadersEnabled = mapped
    }

    /**
     * @param value Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin` or `least_outstanding_requests`. The default is `round_robin`.
     */
    @JvmName("jofvcafoukrynfnb")
    public suspend fun loadBalancingAlgorithmType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingAlgorithmType = mapped
    }

    /**
     * @param value Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
     */
    @JvmName("wfdgrsycbirmbxfl")
    public suspend fun loadBalancingCrossZoneEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingCrossZoneEnabled = mapped
    }

    /**
     * @param value Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    @JvmName("rtnsjueudnldatgs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
     */
    @JvmName("myctcmttwfpgycwx")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
     */
    @JvmName("sqpnowolycbvluok")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
     */
    @JvmName("rjskmfeqssfaskhu")
    public suspend fun preserveClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveClientIp = mapped
    }

    /**
     * @param value Protocol to use for routing traffic to the targets.
     * Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
     * Required when `target_type` is `instance`, `ip`, or `alb`.
     * Does not apply when `target_type` is `lambda`.
     */
    @JvmName("rqnscjeddsrwcgbc")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
     */
    @JvmName("bxnjklfeysntmens")
    public suspend fun protocolVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolVersion = mapped
    }

    /**
     * @param value Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
     */
    @JvmName("bhfyunrdicinxbrk")
    public suspend fun proxyProtocolV2(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyProtocolV2 = mapped
    }

    /**
     * @param value Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
     */
    @JvmName("fqfuprinervfhsli")
    public suspend fun slowStart(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slowStart = mapped
    }

    /**
     * @param value Stickiness configuration block. Detailed below.
     */
    @JvmName("vuarwpcidvmmmobn")
    public suspend fun stickiness(`value`: TargetGroupStickinessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickiness = mapped
    }

    /**
     * @param argument Stickiness configuration block. Detailed below.
     */
    @JvmName("lrpsedllvxqnvaeb")
    public suspend fun stickiness(argument: suspend TargetGroupStickinessArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupStickinessArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stickiness = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xatwxcoloxibhvks")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uhkcksuhfbctfiwl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    @JvmName("vvfsndjpluhulljy")
    public suspend fun targetFailovers(`value`: List<TargetGroupTargetFailoverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFailovers = mapped
    }

    /**
     * @param argument Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    @JvmName("xdtjqttydbkrjqvd")
    public suspend
    fun targetFailovers(argument: List<suspend TargetGroupTargetFailoverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetGroupTargetFailoverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetFailovers = mapped
    }

    /**
     * @param argument Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    @JvmName("mjreguunaveruyde")
    public suspend fun targetFailovers(
        vararg
        argument: suspend TargetGroupTargetFailoverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TargetGroupTargetFailoverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetFailovers = mapped
    }

    /**
     * @param argument Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    @JvmName("upsxcuvghvodhgdh")
    public suspend
    fun targetFailovers(argument: suspend TargetGroupTargetFailoverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TargetGroupTargetFailoverArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetFailovers = mapped
    }

    /**
     * @param values Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    @JvmName("jyukjosnknhqwrvu")
    public suspend fun targetFailovers(vararg values: TargetGroupTargetFailoverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetFailovers = mapped
    }

    /**
     * @param value Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    @JvmName("jkseuquyeowidaws")
    public suspend fun targetHealthStates(`value`: List<TargetGroupTargetHealthStateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetHealthStates = mapped
    }

    /**
     * @param argument Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    @JvmName("kclgudcfwtgcmiqp")
    public suspend
    fun targetHealthStates(argument: List<suspend TargetGroupTargetHealthStateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetGroupTargetHealthStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetHealthStates = mapped
    }

    /**
     * @param argument Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    @JvmName("rxtuxdhmcisucbsu")
    public suspend fun targetHealthStates(
        vararg
        argument: suspend TargetGroupTargetHealthStateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TargetGroupTargetHealthStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetHealthStates = mapped
    }

    /**
     * @param argument Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    @JvmName("ogcbbawghfgtelsm")
    public suspend
    fun targetHealthStates(argument: suspend TargetGroupTargetHealthStateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TargetGroupTargetHealthStateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetHealthStates = mapped
    }

    /**
     * @param values Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    @JvmName("pprkrfuxhtlgqhdq")
    public suspend fun targetHealthStates(vararg values: TargetGroupTargetHealthStateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetHealthStates = mapped
    }

    /**
     * @param value Type of target that you must specify when registering targets with this target group.
     * See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
     * The default is `instance`.
     * Note that you can't specify targets for a target group using both instance IDs and IP addresses.
     * If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
     * Network Load Balancers do not support the `lambda` target type.
     * Application Load Balancers do not support the `alb` target type.
     */
    @JvmName("ikaybgqqcswqfyhq")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
     */
    @JvmName("fjkbmtchbpqeduko")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): TargetGroupArgs = TargetGroupArgs(
        connectionTermination = connectionTermination,
        deregistrationDelay = deregistrationDelay,
        healthCheck = healthCheck,
        ipAddressType = ipAddressType,
        lambdaMultiValueHeadersEnabled = lambdaMultiValueHeadersEnabled,
        loadBalancingAlgorithmType = loadBalancingAlgorithmType,
        loadBalancingCrossZoneEnabled = loadBalancingCrossZoneEnabled,
        name = name,
        namePrefix = namePrefix,
        port = port,
        preserveClientIp = preserveClientIp,
        protocol = protocol,
        protocolVersion = protocolVersion,
        proxyProtocolV2 = proxyProtocolV2,
        slowStart = slowStart,
        stickiness = stickiness,
        tags = tags,
        targetFailovers = targetFailovers,
        targetHealthStates = targetHealthStates,
        targetType = targetType,
        vpcId = vpcId,
    )
}
