@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TargetGroupAttachment].
 */
@PulumiTagMarker
public class TargetGroupAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TargetGroupAttachmentArgs = TargetGroupAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TargetGroupAttachmentArgsBuilder.() -> Unit) {
        val builder = TargetGroupAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TargetGroupAttachment {
        val builtJavaResource = com.pulumi.aws.lb.TargetGroupAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TargetGroupAttachment(builtJavaResource)
    }
}

/**
 * Provides the ability to register instances and containers with an Application Load Balancer (ALB) or Network Load Balancer (NLB) target group. For attaching resources with Elastic Load Balancer (ELB), see the `aws.elb.Attachment` resource.
 * > **Note:** `aws.alb.TargetGroupAttachment` is known as `aws.lb.TargetGroupAttachment`. The functionality is identical.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.lb.TargetGroupAttachment;
 * import com.pulumi.aws.lb.TargetGroupAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTargetGroup = new TargetGroup("testTargetGroup");
 *         var testInstance = new Instance("testInstance");
 *         var testTargetGroupAttachment = new TargetGroupAttachment("testTargetGroupAttachment", TargetGroupAttachmentArgs.builder()
 *             .targetGroupArn(testTargetGroup.arn())
 *             .targetId(testInstance.id())
 *             .port(80)
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.lb.TargetGroupAttachment;
 * import com.pulumi.aws.lb.TargetGroupAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTargetGroup = new TargetGroup("testTargetGroup", TargetGroupArgs.builder()
 *             .targetType("lambda")
 *             .build());
 *         var testFunction = new Function("testFunction");
 *         var withLb = new Permission("withLb", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(testFunction.name())
 *             .principal("elasticloadbalancing.amazonaws.com")
 *             .sourceArn(testTargetGroup.arn())
 *             .build());
 *         var testTargetGroupAttachment = new TargetGroupAttachment("testTargetGroupAttachment", TargetGroupAttachmentArgs.builder()
 *             .targetGroupArn(testTargetGroup.arn())
 *             .targetId(testFunction.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(withLb)
 *                 .build());
 *     }
 * }
 * ```
 * ### Registering Multiple Targets
 * No Java example available.
 * ## Import
 * You cannot import Target Group Attachments.
 */
public class TargetGroupAttachment internal constructor(
    override val javaResource: com.pulumi.aws.lb.TargetGroupAttachment,
) : KotlinCustomResource(javaResource, TargetGroupAttachmentMapper) {
    /**
     * The Availability Zone where the IP address of the target is to be registered. If the private IP address is outside of the VPC scope, this value must be set to `all`.
     */
    public val availabilityZone: Output<String>?
        get() = javaResource.availabilityZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port on which targets receive traffic.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ARN of the target group with which to register targets.
     */
    public val targetGroupArn: Output<String>
        get() = javaResource.targetGroupArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the target. This is the Instance ID for an instance, or the container ID for an ECS container. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the Lambda function ARN. If the target type is `alb`, specify the ALB ARN.
     * The following arguments are optional:
     */
    public val targetId: Output<String>
        get() = javaResource.targetId().applyValue({ args0 -> args0 })
}

public object TargetGroupAttachmentMapper : ResourceMapper<TargetGroupAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lb.TargetGroupAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TargetGroupAttachment =
        TargetGroupAttachment(javaResource as com.pulumi.aws.lb.TargetGroupAttachment)
}

/**
 * @see [TargetGroupAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TargetGroupAttachment].
 */
public suspend fun targetGroupAttachment(
    name: String,
    block: suspend TargetGroupAttachmentResourceBuilder.() -> Unit,
): TargetGroupAttachment {
    val builder = TargetGroupAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TargetGroupAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun targetGroupAttachment(name: String): TargetGroupAttachment {
    val builder = TargetGroupAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
