@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.GetHostedZoneIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHostedZoneId.
 * @property loadBalancerType Type of load balancer to create. Possible values are `application` or `network`. The default value is `application`.
 * @property region Name of the region whose AWS ELB HostedZoneId is desired.
 * Defaults to the region from the AWS provider configuration.
 */
public data class GetHostedZoneIdPlainArgs(
    public val loadBalancerType: String? = null,
    public val region: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.GetHostedZoneIdPlainArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.GetHostedZoneIdPlainArgs =
        com.pulumi.aws.lb.inputs.GetHostedZoneIdPlainArgs.builder()
            .loadBalancerType(loadBalancerType?.let({ args0 -> args0 }))
            .region(region?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostedZoneIdPlainArgs].
 */
@PulumiTagMarker
public class GetHostedZoneIdPlainArgsBuilder internal constructor() {
    private var loadBalancerType: String? = null

    private var region: String? = null

    /**
     * @param value Type of load balancer to create. Possible values are `application` or `network`. The default value is `application`.
     */
    @JvmName("gafspkitdgbyrlna")
    public suspend fun loadBalancerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerType = mapped
    }

    /**
     * @param value Name of the region whose AWS ELB HostedZoneId is desired.
     * Defaults to the region from the AWS provider configuration.
     */
    @JvmName("ymthvkgqanolsnxh")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    internal fun build(): GetHostedZoneIdPlainArgs = GetHostedZoneIdPlainArgs(
        loadBalancerType = loadBalancerType,
        region = region,
    )
}
