@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.GetLbsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLbs.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired Load Balancers.
 */
public data class GetLbsPlainArgs(
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.GetLbsPlainArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.GetLbsPlainArgs =
        com.pulumi.aws.lb.inputs.GetLbsPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLbsPlainArgs].
 */
@PulumiTagMarker
public class GetLbsPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired Load Balancers.
     */
    @JvmName("qhbfotnsfbhscqqv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired Load Balancers.
     */
    @JvmName("gywfbrsrlvfqgegk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLbsPlainArgs = GetLbsPlainArgs(
        tags = tags,
    )
}
