@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.GetLoadBalancerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLoadBalancer.
 * @property arn Full ARN of the load balancer.
 * @property name Unique name of the load balancer.
 * @property tags Mapping of tags, each pair of which must exactly match a pair on the desired load balancer.
 * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has lowest precedence.
 */
public data class GetLoadBalancerPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.GetLoadBalancerPlainArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.GetLoadBalancerPlainArgs =
        com.pulumi.aws.lb.inputs.GetLoadBalancerPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLoadBalancerPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancerPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Full ARN of the load balancer.
     */
    @JvmName("feliqvdtpjyocrlb")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Unique name of the load balancer.
     */
    @JvmName("qwikfrycwdaelyas")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match a pair on the desired load balancer.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has lowest precedence.
     */
    @JvmName("mqfbvlqppsrgphme")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match a pair on the desired load balancer.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has lowest precedence.
     */
    @JvmName("damweyveqriybpiq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLoadBalancerPlainArgs = GetLoadBalancerPlainArgs(
        arn = arn,
        name = name,
        tags = tags,
    )
}
