@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateOidcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationRequestExtraParams Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
 * @property authorizationEndpoint Authorization endpoint of the IdP.
 * @property clientId OAuth 2.0 client identifier.
 * @property clientSecret OAuth 2.0 client secret.
 * @property issuer OIDC issuer identifier of the IdP.
 * @property onUnauthenticatedRequest Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
 * @property scope Set of user claims to be requested from the IdP.
 * @property sessionCookieName Name of the cookie used to maintain session information.
 * @property sessionTimeout Maximum duration of the authentication session, in seconds.
 * @property tokenEndpoint Token endpoint of the IdP.
 * @property userInfoEndpoint User info endpoint of the IdP.
 * The following arguments are optional:
 */
public data class ListenerDefaultActionAuthenticateOidcArgs(
    public val authenticationRequestExtraParams: Output<Map<String, String>>? = null,
    public val authorizationEndpoint: Output<String>,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
    public val issuer: Output<String>,
    public val onUnauthenticatedRequest: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sessionCookieName: Output<String>? = null,
    public val sessionTimeout: Output<Int>? = null,
    public val tokenEndpoint: Output<String>,
    public val userInfoEndpoint: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateOidcArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateOidcArgs =
        com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateOidcArgs.builder()
            .authenticationRequestExtraParams(
                authenticationRequestExtraParams?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .authorizationEndpoint(authorizationEndpoint.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .issuer(issuer.applyValue({ args0 -> args0 }))
            .onUnauthenticatedRequest(onUnauthenticatedRequest?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sessionCookieName(sessionCookieName?.applyValue({ args0 -> args0 }))
            .sessionTimeout(sessionTimeout?.applyValue({ args0 -> args0 }))
            .tokenEndpoint(tokenEndpoint.applyValue({ args0 -> args0 }))
            .userInfoEndpoint(userInfoEndpoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionAuthenticateOidcArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionAuthenticateOidcArgsBuilder internal constructor() {
    private var authenticationRequestExtraParams: Output<Map<String, String>>? = null

    private var authorizationEndpoint: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var issuer: Output<String>? = null

    private var onUnauthenticatedRequest: Output<String>? = null

    private var scope: Output<String>? = null

    private var sessionCookieName: Output<String>? = null

    private var sessionTimeout: Output<Int>? = null

    private var tokenEndpoint: Output<String>? = null

    private var userInfoEndpoint: Output<String>? = null

    /**
     * @param value Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("ofxtfgrfejlqvdvy")
    public suspend fun authenticationRequestExtraParams(`value`: Output<Map<String, String>>) {
        this.authenticationRequestExtraParams = value
    }

    /**
     * @param value Authorization endpoint of the IdP.
     */
    @JvmName("kdjluiratsjbimfb")
    public suspend fun authorizationEndpoint(`value`: Output<String>) {
        this.authorizationEndpoint = value
    }

    /**
     * @param value OAuth 2.0 client identifier.
     */
    @JvmName("ssbvufashfeqjnqm")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value OAuth 2.0 client secret.
     */
    @JvmName("lgyihdttxkmgyllp")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value OIDC issuer identifier of the IdP.
     */
    @JvmName("utxlmbbqfmecewov")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
     */
    @JvmName("glowmbkaiiorfjvs")
    public suspend fun onUnauthenticatedRequest(`value`: Output<String>) {
        this.onUnauthenticatedRequest = value
    }

    /**
     * @param value Set of user claims to be requested from the IdP.
     */
    @JvmName("wbhxkustpcniojnd")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Name of the cookie used to maintain session information.
     */
    @JvmName("yslmqtxxkfbbiodi")
    public suspend fun sessionCookieName(`value`: Output<String>) {
        this.sessionCookieName = value
    }

    /**
     * @param value Maximum duration of the authentication session, in seconds.
     */
    @JvmName("gsxvkvjtaxwykbyg")
    public suspend fun sessionTimeout(`value`: Output<Int>) {
        this.sessionTimeout = value
    }

    /**
     * @param value Token endpoint of the IdP.
     */
    @JvmName("ywlrunkntxojsuhu")
    public suspend fun tokenEndpoint(`value`: Output<String>) {
        this.tokenEndpoint = value
    }

    /**
     * @param value User info endpoint of the IdP.
     * The following arguments are optional:
     */
    @JvmName("wymdsytsqyjcdcrx")
    public suspend fun userInfoEndpoint(`value`: Output<String>) {
        this.userInfoEndpoint = value
    }

    /**
     * @param value Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("kdheplaviivtioeq")
    public suspend fun authenticationRequestExtraParams(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param values Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("slpvrrkpyiixgcsf")
    public fun authenticationRequestExtraParams(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param value Authorization endpoint of the IdP.
     */
    @JvmName("nlonevmfteeaaucq")
    public suspend fun authorizationEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationEndpoint = mapped
    }

    /**
     * @param value OAuth 2.0 client identifier.
     */
    @JvmName("epcpsyowwocgnnav")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value OAuth 2.0 client secret.
     */
    @JvmName("pqwvejvahpkpveui")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value OIDC issuer identifier of the IdP.
     */
    @JvmName("jmdvteltmoamrejb")
    public suspend fun issuer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
     */
    @JvmName("joywtnhrjmuugfap")
    public suspend fun onUnauthenticatedRequest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onUnauthenticatedRequest = mapped
    }

    /**
     * @param value Set of user claims to be requested from the IdP.
     */
    @JvmName("olyeoniudtrefafj")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Name of the cookie used to maintain session information.
     */
    @JvmName("xqqatyoynicujmxr")
    public suspend fun sessionCookieName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionCookieName = mapped
    }

    /**
     * @param value Maximum duration of the authentication session, in seconds.
     */
    @JvmName("tvoeuivvvgsjjhqn")
    public suspend fun sessionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeout = mapped
    }

    /**
     * @param value Token endpoint of the IdP.
     */
    @JvmName("uhaujhcvskyjwhdg")
    public suspend fun tokenEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenEndpoint = mapped
    }

    /**
     * @param value User info endpoint of the IdP.
     * The following arguments are optional:
     */
    @JvmName("xvkfwjdhogxkbfxm")
    public suspend fun userInfoEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userInfoEndpoint = mapped
    }

    internal fun build(): ListenerDefaultActionAuthenticateOidcArgs =
        ListenerDefaultActionAuthenticateOidcArgs(
            authenticationRequestExtraParams = authenticationRequestExtraParams,
            authorizationEndpoint = authorizationEndpoint ?: throw
                PulumiNullFieldException("authorizationEndpoint"),
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
            issuer = issuer ?: throw PulumiNullFieldException("issuer"),
            onUnauthenticatedRequest = onUnauthenticatedRequest,
            scope = scope,
            sessionCookieName = sessionCookieName,
            sessionTimeout = sessionTimeout,
            tokenEndpoint = tokenEndpoint ?: throw PulumiNullFieldException("tokenEndpoint"),
            userInfoEndpoint = userInfoEndpoint ?: throw PulumiNullFieldException("userInfoEndpoint"),
        )
}
