@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardTargetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of the target group.
 * The following arguments are optional:
 * @property weight Weight. The range is 0 to 999.
 */
public data class ListenerDefaultActionForwardTargetGroupArgs(
    public val arn: Output<String>,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardTargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardTargetGroupArgs =
        com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardTargetGroupArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionForwardTargetGroupArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionForwardTargetGroupArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value ARN of the target group.
     * The following arguments are optional:
     */
    @JvmName("ifsaftgmradncwgd")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Weight. The range is 0 to 999.
     */
    @JvmName("rmextslxaxrmhaid")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value ARN of the target group.
     * The following arguments are optional:
     */
    @JvmName("cvyoapxfyhumyqvn")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Weight. The range is 0 to 999.
     */
    @JvmName("yhgdguppbevrievu")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ListenerDefaultActionForwardTargetGroupArgs =
        ListenerDefaultActionForwardTargetGroupArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            weight = weight,
        )
}
