@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateCognitoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationRequestExtraParams The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
 * @property onUnauthenticatedRequest The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
 * @property scope The set of user claims to be requested from the IdP.
 * @property sessionCookieName The name of the cookie used to maintain session information.
 * @property sessionTimeout The maximum duration of the authentication session, in seconds.
 * @property userPoolArn The ARN of the Cognito user pool.
 * @property userPoolClientId The ID of the Cognito user pool client.
 * @property userPoolDomain The domain prefix or fully-qualified domain name of the Cognito user pool.
 */
public data class ListenerRuleActionAuthenticateCognitoArgs(
    public val authenticationRequestExtraParams: Output<Map<String, String>>? = null,
    public val onUnauthenticatedRequest: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sessionCookieName: Output<String>? = null,
    public val sessionTimeout: Output<Int>? = null,
    public val userPoolArn: Output<String>,
    public val userPoolClientId: Output<String>,
    public val userPoolDomain: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateCognitoArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateCognitoArgs =
        com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateCognitoArgs.builder()
            .authenticationRequestExtraParams(
                authenticationRequestExtraParams?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .onUnauthenticatedRequest(onUnauthenticatedRequest?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sessionCookieName(sessionCookieName?.applyValue({ args0 -> args0 }))
            .sessionTimeout(sessionTimeout?.applyValue({ args0 -> args0 }))
            .userPoolArn(userPoolArn.applyValue({ args0 -> args0 }))
            .userPoolClientId(userPoolClientId.applyValue({ args0 -> args0 }))
            .userPoolDomain(userPoolDomain.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionAuthenticateCognitoArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionAuthenticateCognitoArgsBuilder internal constructor() {
    private var authenticationRequestExtraParams: Output<Map<String, String>>? = null

    private var onUnauthenticatedRequest: Output<String>? = null

    private var scope: Output<String>? = null

    private var sessionCookieName: Output<String>? = null

    private var sessionTimeout: Output<Int>? = null

    private var userPoolArn: Output<String>? = null

    private var userPoolClientId: Output<String>? = null

    private var userPoolDomain: Output<String>? = null

    /**
     * @param value The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("sygekkvyacscwjmo")
    public suspend fun authenticationRequestExtraParams(`value`: Output<Map<String, String>>) {
        this.authenticationRequestExtraParams = value
    }

    /**
     * @param value The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
     */
    @JvmName("vacbnjfrwpyddxvs")
    public suspend fun onUnauthenticatedRequest(`value`: Output<String>) {
        this.onUnauthenticatedRequest = value
    }

    /**
     * @param value The set of user claims to be requested from the IdP.
     */
    @JvmName("aotvopnrjoomykba")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The name of the cookie used to maintain session information.
     */
    @JvmName("vlaqknaawsgkqphv")
    public suspend fun sessionCookieName(`value`: Output<String>) {
        this.sessionCookieName = value
    }

    /**
     * @param value The maximum duration of the authentication session, in seconds.
     */
    @JvmName("kelpcufxnxabinmo")
    public suspend fun sessionTimeout(`value`: Output<Int>) {
        this.sessionTimeout = value
    }

    /**
     * @param value The ARN of the Cognito user pool.
     */
    @JvmName("htuywfesghsulprg")
    public suspend fun userPoolArn(`value`: Output<String>) {
        this.userPoolArn = value
    }

    /**
     * @param value The ID of the Cognito user pool client.
     */
    @JvmName("ksevgaqxoanhjbfx")
    public suspend fun userPoolClientId(`value`: Output<String>) {
        this.userPoolClientId = value
    }

    /**
     * @param value The domain prefix or fully-qualified domain name of the Cognito user pool.
     */
    @JvmName("oabijfnecqmpbynq")
    public suspend fun userPoolDomain(`value`: Output<String>) {
        this.userPoolDomain = value
    }

    /**
     * @param value The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("tbymjkcefmdjuleb")
    public suspend fun authenticationRequestExtraParams(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param values The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("hqwrkcwgdclgspmr")
    public fun authenticationRequestExtraParams(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param value The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
     */
    @JvmName("ktuveugsmnxjypok")
    public suspend fun onUnauthenticatedRequest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onUnauthenticatedRequest = mapped
    }

    /**
     * @param value The set of user claims to be requested from the IdP.
     */
    @JvmName("ulhsaokhxgdgkuaq")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The name of the cookie used to maintain session information.
     */
    @JvmName("vtytonvjwjbrjywe")
    public suspend fun sessionCookieName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionCookieName = mapped
    }

    /**
     * @param value The maximum duration of the authentication session, in seconds.
     */
    @JvmName("ekeaupgginocolkg")
    public suspend fun sessionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeout = mapped
    }

    /**
     * @param value The ARN of the Cognito user pool.
     */
    @JvmName("hfecxoomcbqixapf")
    public suspend fun userPoolArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolArn = mapped
    }

    /**
     * @param value The ID of the Cognito user pool client.
     */
    @JvmName("rfftlejxciadcrkw")
    public suspend fun userPoolClientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolClientId = mapped
    }

    /**
     * @param value The domain prefix or fully-qualified domain name of the Cognito user pool.
     */
    @JvmName("mbgjfqpolauewfnc")
    public suspend fun userPoolDomain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolDomain = mapped
    }

    internal fun build(): ListenerRuleActionAuthenticateCognitoArgs =
        ListenerRuleActionAuthenticateCognitoArgs(
            authenticationRequestExtraParams = authenticationRequestExtraParams,
            onUnauthenticatedRequest = onUnauthenticatedRequest,
            scope = scope,
            sessionCookieName = sessionCookieName,
            sessionTimeout = sessionTimeout,
            userPoolArn = userPoolArn ?: throw PulumiNullFieldException("userPoolArn"),
            userPoolClientId = userPoolClientId ?: throw PulumiNullFieldException("userPoolClientId"),
            userPoolDomain = userPoolDomain ?: throw PulumiNullFieldException("userPoolDomain"),
        )
}
