@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerRuleActionForwardStickinessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property duration The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
 * @property enabled Indicates whether target group stickiness is enabled.
 */
public data class ListenerRuleActionForwardStickinessArgs(
    public val duration: Output<Int>,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerRuleActionForwardStickinessArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerRuleActionForwardStickinessArgs =
        com.pulumi.aws.lb.inputs.ListenerRuleActionForwardStickinessArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionForwardStickinessArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionForwardStickinessArgsBuilder internal constructor() {
    private var duration: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
     */
    @JvmName("jsghxdyqhiperdqh")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value Indicates whether target group stickiness is enabled.
     */
    @JvmName("uvyfrbvdbsxwsvrc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
     */
    @JvmName("wsdrbxwicduipukw")
    public suspend fun duration(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Indicates whether target group stickiness is enabled.
     */
    @JvmName("iyrdocutvtakjyht")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ListenerRuleActionForwardStickinessArgs =
        ListenerRuleActionForwardStickinessArgs(
            duration = duration ?: throw PulumiNullFieldException("duration"),
            enabled = enabled,
        )
}
