@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerRuleActionForwardTargetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the target group.
 * @property weight The weight. The range is 0 to 999.
 */
public data class ListenerRuleActionForwardTargetGroupArgs(
    public val arn: Output<String>,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerRuleActionForwardTargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerRuleActionForwardTargetGroupArgs =
        com.pulumi.aws.lb.inputs.ListenerRuleActionForwardTargetGroupArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionForwardTargetGroupArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionForwardTargetGroupArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the target group.
     */
    @JvmName("ulmysuwuvpgtnwcd")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The weight. The range is 0 to 999.
     */
    @JvmName("obvxfusarltagmyg")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the target group.
     */
    @JvmName("fjyqytejammtmokt")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The weight. The range is 0 to 999.
     */
    @JvmName("tqmlghxbioatviyo")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ListenerRuleActionForwardTargetGroupArgs =
        ListenerRuleActionForwardTargetGroupArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            weight = weight,
        )
}
