@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerRuleConditionHttpHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property httpHeaderName Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
 * @property values List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
 */
public data class ListenerRuleConditionHttpHeaderArgs(
    public val httpHeaderName: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerRuleConditionHttpHeaderArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerRuleConditionHttpHeaderArgs =
        com.pulumi.aws.lb.inputs.ListenerRuleConditionHttpHeaderArgs.builder()
            .httpHeaderName(httpHeaderName.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ListenerRuleConditionHttpHeaderArgs].
 */
@PulumiTagMarker
public class ListenerRuleConditionHttpHeaderArgsBuilder internal constructor() {
    private var httpHeaderName: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
     */
    @JvmName("afcqrqwkotlpwjbg")
    public suspend fun httpHeaderName(`value`: Output<String>) {
        this.httpHeaderName = value
    }

    /**
     * @param value List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
     */
    @JvmName("ytrbxlcwghmbxegu")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("wafecfiussixewew")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
     */
    @JvmName("nudsgssklalwksaw")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
     */
    @JvmName("pnecgfeiijphgler")
    public suspend fun httpHeaderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeaderName = mapped
    }

    /**
     * @param value List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
     */
    @JvmName("umsyrjysmtnkymth")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
     */
    @JvmName("opuvqlhxkampxwci")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ListenerRuleConditionHttpHeaderArgs = ListenerRuleConditionHttpHeaderArgs(
        httpHeaderName = httpHeaderName ?: throw PulumiNullFieldException("httpHeaderName"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
