@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.LoadBalancerAccessLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The S3 bucket name to store the logs in.
 * @property enabled Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
 * @property prefix The S3 bucket prefix. Logs are stored in the root if not configured.
 */
public data class LoadBalancerAccessLogsArgs(
    public val bucket: Output<String>,
    public val enabled: Output<Boolean>? = null,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.LoadBalancerAccessLogsArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.LoadBalancerAccessLogsArgs =
        com.pulumi.aws.lb.inputs.LoadBalancerAccessLogsArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerAccessLogsArgs].
 */
@PulumiTagMarker
public class LoadBalancerAccessLogsArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The S3 bucket name to store the logs in.
     */
    @JvmName("smnyhwuhgqadnlbl")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
     */
    @JvmName("ttckljkwufbljisf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The S3 bucket prefix. Logs are stored in the root if not configured.
     */
    @JvmName("onbudcjxrhouuolm")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The S3 bucket name to store the logs in.
     */
    @JvmName("hjtwikkeejknxsrw")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
     */
    @JvmName("camtukagpdojbguf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The S3 bucket prefix. Logs are stored in the root if not configured.
     */
    @JvmName("cnkkfyijmkkkkfug")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): LoadBalancerAccessLogsArgs = LoadBalancerAccessLogsArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        enabled = enabled,
        prefix = prefix,
    )
}
