@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.TargetGroupHealthCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether health checks are enabled. Defaults to `true`.
 * @property healthyThreshold Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
 * @property interval Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
 * @property matcher The HTTP or gRPC codes to use when checking for a successful response from a target.
 * The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
 * Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
 * * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
 * * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
 * * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
 * * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
 * @property path Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
 * * For HTTP and HTTPS health checks, the default is `/`.
 * * For gRPC health checks, the default is `/Amazon Web Services.ALB/healthcheck`.
 * @property port The port the load balancer uses when performing health checks on targets.
 * Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
 * Default is `traffic-port`.
 * @property protocol Protocol the load balancer uses when performing health checks on targets.
 * Must be one of `TCP`, `HTTP`, or `HTTPS`.
 * The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
 * Default is `HTTP`.
 * Cannot be specified when the `target_type` is `lambda`.
 * @property timeout Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
 * @property unhealthyThreshold Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
 */
public data class TargetGroupHealthCheckArgs(
    public val enabled: Output<Boolean>? = null,
    public val healthyThreshold: Output<Int>? = null,
    public val interval: Output<Int>? = null,
    public val matcher: Output<String>? = null,
    public val path: Output<String>? = null,
    public val port: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val timeout: Output<Int>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.TargetGroupHealthCheckArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.TargetGroupHealthCheckArgs =
        com.pulumi.aws.lb.inputs.TargetGroupHealthCheckArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .healthyThreshold(healthyThreshold?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .matcher(matcher?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupHealthCheckArgs].
 */
@PulumiTagMarker
public class TargetGroupHealthCheckArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var healthyThreshold: Output<Int>? = null

    private var interval: Output<Int>? = null

    private var matcher: Output<String>? = null

    private var path: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value Whether health checks are enabled. Defaults to `true`.
     */
    @JvmName("llmqfrrbooktjoxj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
     */
    @JvmName("skxdefrporkmkigc")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
     */
    @JvmName("oqfgkpahwtkipghh")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The HTTP or gRPC codes to use when checking for a successful response from a target.
     * The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
     * Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
     * * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
     * * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
     * * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
     * * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
     */
    @JvmName("hoecnepjyeujgvul")
    public suspend fun matcher(`value`: Output<String>) {
        this.matcher = value
    }

    /**
     * @param value Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
     * * For HTTP and HTTPS health checks, the default is `/`.
     * * For gRPC health checks, the default is `/Amazon Web Services.ALB/healthcheck`.
     */
    @JvmName("yldmwvhwcoqssvur")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The port the load balancer uses when performing health checks on targets.
     * Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
     * Default is `traffic-port`.
     */
    @JvmName("aubtcivpleslkucb")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Protocol the load balancer uses when performing health checks on targets.
     * Must be one of `TCP`, `HTTP`, or `HTTPS`.
     * The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
     * Default is `HTTP`.
     * Cannot be specified when the `target_type` is `lambda`.
     */
    @JvmName("mbrbxjtlwuojwabl")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
     */
    @JvmName("ohhnarjbenrehcmu")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
     */
    @JvmName("cxjbotsdsuhhalyg")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value Whether health checks are enabled. Defaults to `true`.
     */
    @JvmName("owlnijogrkavgrln")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
     */
    @JvmName("xlcxpegxnarhkdxg")
    public suspend fun healthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
     */
    @JvmName("cjmbpamkslkyqvin")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The HTTP or gRPC codes to use when checking for a successful response from a target.
     * The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
     * Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
     * * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
     * * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
     * * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
     * * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
     */
    @JvmName("irfnnqgsdbrynnnx")
    public suspend fun matcher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matcher = mapped
    }

    /**
     * @param value Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
     * * For HTTP and HTTPS health checks, the default is `/`.
     * * For gRPC health checks, the default is `/Amazon Web Services.ALB/healthcheck`.
     */
    @JvmName("qyjhlkjdmrwcbsim")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The port the load balancer uses when performing health checks on targets.
     * Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
     * Default is `traffic-port`.
     */
    @JvmName("iksfbfoakhccsjxi")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol the load balancer uses when performing health checks on targets.
     * Must be one of `TCP`, `HTTP`, or `HTTPS`.
     * The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
     * Default is `HTTP`.
     * Cannot be specified when the `target_type` is `lambda`.
     */
    @JvmName("cwrfxnnesoyuurji")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
     */
    @JvmName("smsgfbaydkvpgvop")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
     */
    @JvmName("puopfrvtrckasscu")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): TargetGroupHealthCheckArgs = TargetGroupHealthCheckArgs(
        enabled = enabled,
        healthyThreshold = healthyThreshold,
        interval = interval,
        matcher = matcher,
        path = path,
        port = port,
        protocol = protocol,
        timeout = timeout,
        unhealthyThreshold = unhealthyThreshold,
    )
}
