@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLbs.
 * @property arns Set of Load Balancer ARNs.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags
 */
public data class GetLbsResult(
    public val arns: List<String>,
    public val id: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.GetLbsResult): GetLbsResult =
            GetLbsResult(
                arns = javaType.arns().map({ args0 -> args0 }),
                id = javaType.id(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
