@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authenticateCognitos
 * @property authenticateOidcs
 * @property fixedResponses
 * @property forwards
 * @property order
 * @property redirects
 * @property targetGroupArn
 * @property type
 */
public data class GetListenerDefaultAction(
    public val authenticateCognitos: List<GetListenerDefaultActionAuthenticateCognito>,
    public val authenticateOidcs: List<GetListenerDefaultActionAuthenticateOidc>,
    public val fixedResponses: List<GetListenerDefaultActionFixedResponse>,
    public val forwards: List<GetListenerDefaultActionForward>,
    public val order: Int,
    public val redirects: List<GetListenerDefaultActionRedirect>,
    public val targetGroupArn: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.GetListenerDefaultAction):
            GetListenerDefaultAction = GetListenerDefaultAction(
            authenticateCognitos = javaType.authenticateCognitos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.GetListenerDefaultActionAuthenticateCognito.Companion.toKotlin(args0)
                })
            }),
            authenticateOidcs = javaType.authenticateOidcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.GetListenerDefaultActionAuthenticateOidc.Companion.toKotlin(args0)
                })
            }),
            fixedResponses = javaType.fixedResponses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.GetListenerDefaultActionFixedResponse.Companion.toKotlin(args0)
                })
            }),
            forwards = javaType.forwards().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.GetListenerDefaultActionForward.Companion.toKotlin(args0)
                })
            }),
            order = javaType.order(),
            redirects = javaType.redirects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.GetListenerDefaultActionRedirect.Companion.toKotlin(args0)
                })
            }),
            targetGroupArn = javaType.targetGroupArn(),
            type = javaType.type(),
        )
    }
}
