@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getTargetGroup.
 * @property arn
 * @property arnSuffix
 * @property connectionTermination
 * @property deregistrationDelay
 * @property healthCheck
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lambdaMultiValueHeadersEnabled
 * @property loadBalancingAlgorithmType
 * @property loadBalancingCrossZoneEnabled
 * @property name
 * @property port
 * @property preserveClientIp
 * @property protocol
 * @property protocolVersion
 * @property proxyProtocolV2
 * @property slowStart
 * @property stickiness
 * @property tags
 * @property targetType
 * @property vpcId
 */
public data class GetTargetGroupResult(
    public val arn: String,
    public val arnSuffix: String,
    public val connectionTermination: Boolean,
    public val deregistrationDelay: Int,
    public val healthCheck: GetTargetGroupHealthCheck,
    public val id: String,
    public val lambdaMultiValueHeadersEnabled: Boolean,
    public val loadBalancingAlgorithmType: String,
    public val loadBalancingCrossZoneEnabled: String,
    public val name: String,
    public val port: Int,
    public val preserveClientIp: String,
    public val protocol: String,
    public val protocolVersion: String,
    public val proxyProtocolV2: Boolean,
    public val slowStart: Int,
    public val stickiness: GetTargetGroupStickiness,
    public val tags: Map<String, String>,
    public val targetType: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.GetTargetGroupResult):
            GetTargetGroupResult = GetTargetGroupResult(
            arn = javaType.arn(),
            arnSuffix = javaType.arnSuffix(),
            connectionTermination = javaType.connectionTermination(),
            deregistrationDelay = javaType.deregistrationDelay(),
            healthCheck = javaType.healthCheck().let({ args0 ->
                com.pulumi.aws.lb.kotlin.outputs.GetTargetGroupHealthCheck.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            lambdaMultiValueHeadersEnabled = javaType.lambdaMultiValueHeadersEnabled(),
            loadBalancingAlgorithmType = javaType.loadBalancingAlgorithmType(),
            loadBalancingCrossZoneEnabled = javaType.loadBalancingCrossZoneEnabled(),
            name = javaType.name(),
            port = javaType.port(),
            preserveClientIp = javaType.preserveClientIp(),
            protocol = javaType.protocol(),
            protocolVersion = javaType.protocolVersion(),
            proxyProtocolV2 = javaType.proxyProtocolV2(),
            slowStart = javaType.slowStart(),
            stickiness = javaType.stickiness().let({ args0 ->
                com.pulumi.aws.lb.kotlin.outputs.GetTargetGroupStickiness.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetType = javaType.targetType(),
            vpcId = javaType.vpcId(),
        )
    }
}
