@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contentType Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
 * The following arguments are optional:
 * @property messageBody Message body.
 * @property statusCode HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
 */
public data class ListenerDefaultActionFixedResponse(
    public val contentType: String,
    public val messageBody: String? = null,
    public val statusCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerDefaultActionFixedResponse):
            ListenerDefaultActionFixedResponse = ListenerDefaultActionFixedResponse(
            contentType = javaType.contentType(),
            messageBody = javaType.messageBody().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
