@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property host Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
 * @property path Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
 * @property port Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
 * @property protocol Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
 * @property query Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
 * @property statusCode HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
 * The following arguments are optional:
 */
public data class ListenerDefaultActionRedirect(
    public val host: String? = null,
    public val path: String? = null,
    public val port: String? = null,
    public val protocol: String? = null,
    public val query: String? = null,
    public val statusCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerDefaultActionRedirect):
            ListenerDefaultActionRedirect = ListenerDefaultActionRedirect(
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode(),
        )
    }
}
