@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticateCognito Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
 * @property authenticateOidc Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
 * @property fixedResponse Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
 * @property forward Information for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`.
 * @property order
 * @property redirect Information for creating a redirect action. Required if `type` is `redirect`.
 * @property targetGroupArn The ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
 * @property type The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
 */
public data class ListenerRuleAction(
    public val authenticateCognito: ListenerRuleActionAuthenticateCognito? = null,
    public val authenticateOidc: ListenerRuleActionAuthenticateOidc? = null,
    public val fixedResponse: ListenerRuleActionFixedResponse? = null,
    public val forward: ListenerRuleActionForward? = null,
    public val order: Int? = null,
    public val redirect: ListenerRuleActionRedirect? = null,
    public val targetGroupArn: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerRuleAction): ListenerRuleAction =
            ListenerRuleAction(
                authenticateCognito = javaType.authenticateCognito().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lb.kotlin.outputs.ListenerRuleActionAuthenticateCognito.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                authenticateOidc = javaType.authenticateOidc().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lb.kotlin.outputs.ListenerRuleActionAuthenticateOidc.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fixedResponse = javaType.fixedResponse().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lb.kotlin.outputs.ListenerRuleActionFixedResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                forward = javaType.forward().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lb.kotlin.outputs.ListenerRuleActionForward.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                order = javaType.order().map({ args0 -> args0 }).orElse(null),
                redirect = javaType.redirect().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lb.kotlin.outputs.ListenerRuleActionRedirect.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                targetGroupArn = javaType.targetGroupArn().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
