@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authenticationRequestExtraParams The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
 * @property onUnauthenticatedRequest The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
 * @property scope The set of user claims to be requested from the IdP.
 * @property sessionCookieName The name of the cookie used to maintain session information.
 * @property sessionTimeout The maximum duration of the authentication session, in seconds.
 * @property userPoolArn The ARN of the Cognito user pool.
 * @property userPoolClientId The ID of the Cognito user pool client.
 * @property userPoolDomain The domain prefix or fully-qualified domain name of the Cognito user pool.
 */
public data class ListenerRuleActionAuthenticateCognito(
    public val authenticationRequestExtraParams: Map<String, String>? = null,
    public val onUnauthenticatedRequest: String? = null,
    public val scope: String? = null,
    public val sessionCookieName: String? = null,
    public val sessionTimeout: Int? = null,
    public val userPoolArn: String,
    public val userPoolClientId: String,
    public val userPoolDomain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerRuleActionAuthenticateCognito):
            ListenerRuleActionAuthenticateCognito = ListenerRuleActionAuthenticateCognito(
            authenticationRequestExtraParams = javaType.authenticationRequestExtraParams().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            onUnauthenticatedRequest = javaType.onUnauthenticatedRequest().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            sessionCookieName = javaType.sessionCookieName().map({ args0 -> args0 }).orElse(null),
            sessionTimeout = javaType.sessionTimeout().map({ args0 -> args0 }).orElse(null),
            userPoolArn = javaType.userPoolArn(),
            userPoolClientId = javaType.userPoolClientId(),
            userPoolDomain = javaType.userPoolDomain(),
        )
    }
}
