@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the target group.
 * @property weight The weight. The range is 0 to 999.
 */
public data class ListenerRuleActionForwardTargetGroup(
    public val arn: String,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerRuleActionForwardTargetGroup):
            ListenerRuleActionForwardTargetGroup = ListenerRuleActionForwardTargetGroup(
            arn = javaType.arn(),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
