@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hostHeader Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
 * @property httpHeader HTTP headers to match. HTTP Header block fields documented below.
 * @property httpRequestMethod Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
 * @property pathPattern Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
 * @property queryStrings Query strings to match. Query String block fields documented below.
 * @property sourceIp Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
 * > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
 */
public data class ListenerRuleCondition(
    public val hostHeader: ListenerRuleConditionHostHeader? = null,
    public val httpHeader: ListenerRuleConditionHttpHeader? = null,
    public val httpRequestMethod: ListenerRuleConditionHttpRequestMethod? = null,
    public val pathPattern: ListenerRuleConditionPathPattern? = null,
    public val queryStrings: List<ListenerRuleConditionQueryString>? = null,
    public val sourceIp: ListenerRuleConditionSourceIp? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerRuleCondition):
            ListenerRuleCondition = ListenerRuleCondition(
            hostHeader = javaType.hostHeader().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.ListenerRuleConditionHostHeader.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpHeader = javaType.httpHeader().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.ListenerRuleConditionHttpHeader.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpRequestMethod = javaType.httpRequestMethod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.ListenerRuleConditionHttpRequestMethod.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pathPattern = javaType.pathPattern().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.ListenerRuleConditionPathPattern.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queryStrings = javaType.queryStrings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.ListenerRuleConditionQueryString.Companion.toKotlin(args0)
                })
            }),
            sourceIp = javaType.sourceIp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.ListenerRuleConditionSourceIp.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
