@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationId The allocation ID of the Elastic IP address for an internet-facing load balancer.
 * @property ipv6Address The IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
 * @property outpostId
 * @property privateIpv4Address The private IPv4 address for an internal load balancer.
 * @property subnetId ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
 */
public data class LoadBalancerSubnetMapping(
    public val allocationId: String? = null,
    public val ipv6Address: String? = null,
    public val outpostId: String? = null,
    public val privateIpv4Address: String? = null,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.LoadBalancerSubnetMapping):
            LoadBalancerSubnetMapping = LoadBalancerSubnetMapping(
            allocationId = javaType.allocationId().map({ args0 -> args0 }).orElse(null),
            ipv6Address = javaType.ipv6Address().map({ args0 -> args0 }).orElse(null),
            outpostId = javaType.outpostId().map({ args0 -> args0 }).orElse(null),
            privateIpv4Address = javaType.privateIpv4Address().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId(),
        )
    }
}
