@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.BotAliasConversationLogs
import com.pulumi.aws.lex.kotlin.outputs.BotAliasConversationLogs.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BotAlias].
 */
@PulumiTagMarker
public class BotAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BotAliasArgs = BotAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BotAliasArgsBuilder.() -> Unit) {
        val builder = BotAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BotAlias {
        val builtJavaResource = com.pulumi.aws.lex.BotAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BotAlias(builtJavaResource)
    }
}

/**
 * Provides an Amazon Lex Bot Alias resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.BotAlias;
 * import com.pulumi.aws.lex.BotAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderFlowersProd = new BotAlias("orderFlowersProd", BotAliasArgs.builder()
 *             .botName("OrderFlowers")
 *             .botVersion("1")
 *             .description("Production Version of the OrderFlowers Bot.")
 *             .name("OrderFlowersProd")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import bot aliases using an ID with the format `bot_name:bot_alias_name`. For example:
 * ```sh
 *  $ pulumi import aws:lex/botAlias:BotAlias order_flowers_prod OrderFlowers:OrderFlowersProd
 * ```
 *
 */
public class BotAlias internal constructor(
    override val javaResource: com.pulumi.aws.lex.BotAlias,
) : KotlinCustomResource(javaResource, BotAliasMapper) {
    /**
     * The ARN of the bot alias.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the bot.
     */
    public val botName: Output<String>
        get() = javaResource.botName().applyValue({ args0 -> args0 })

    /**
     * The version of the bot.
     */
    public val botVersion: Output<String>
        get() = javaResource.botVersion().applyValue({ args0 -> args0 })

    /**
     * Checksum of the bot alias.
     */
    public val checksum: Output<String>
        get() = javaResource.checksum().applyValue({ args0 -> args0 })

    /**
     * The settings that determine how Amazon Lex uses conversation logs for the alias. Attributes are documented under conversation_logs.
     */
    public val conversationLogs: Output<BotAliasConversationLogs>?
        get() = javaResource.conversationLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The date that the bot alias was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * A description of the alias. Must be less than or equal to 200 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * The name of the alias. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object BotAliasMapper : ResourceMapper<BotAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.BotAlias::class == javaResource::class

    override fun map(javaResource: Resource): BotAlias = BotAlias(
        javaResource as
            com.pulumi.aws.lex.BotAlias,
    )
}

/**
 * @see [BotAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BotAlias].
 */
public suspend fun botAlias(name: String, block: suspend BotAliasResourceBuilder.() -> Unit):
    BotAlias {
    val builder = BotAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BotAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun botAlias(name: String): BotAlias {
    val builder = BotAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
