@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.BotAliasArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.BotAliasConversationLogsArgs
import com.pulumi.aws.lex.kotlin.inputs.BotAliasConversationLogsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Lex Bot Alias resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.BotAlias;
 * import com.pulumi.aws.lex.BotAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderFlowersProd = new BotAlias("orderFlowersProd", BotAliasArgs.builder()
 *             .botName("OrderFlowers")
 *             .botVersion("1")
 *             .description("Production Version of the OrderFlowers Bot.")
 *             .name("OrderFlowersProd")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import bot aliases using an ID with the format `bot_name:bot_alias_name`. For example:
 * ```sh
 *  $ pulumi import aws:lex/botAlias:BotAlias order_flowers_prod OrderFlowers:OrderFlowersProd
 * ```
 * @property botName The name of the bot.
 * @property botVersion The version of the bot.
 * @property conversationLogs The settings that determine how Amazon Lex uses conversation logs for the alias. Attributes are documented under conversation_logs.
 * @property description A description of the alias. Must be less than or equal to 200 characters in length.
 * @property name The name of the alias. The name is not case sensitive. Must be less than or equal to 100 characters in length.
 */
public data class BotAliasArgs(
    public val botName: Output<String>? = null,
    public val botVersion: Output<String>? = null,
    public val conversationLogs: Output<BotAliasConversationLogsArgs>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.BotAliasArgs> {
    override fun toJava(): com.pulumi.aws.lex.BotAliasArgs = com.pulumi.aws.lex.BotAliasArgs.builder()
        .botName(botName?.applyValue({ args0 -> args0 }))
        .botVersion(botVersion?.applyValue({ args0 -> args0 }))
        .conversationLogs(conversationLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .description(description?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotAliasArgs].
 */
@PulumiTagMarker
public class BotAliasArgsBuilder internal constructor() {
    private var botName: Output<String>? = null

    private var botVersion: Output<String>? = null

    private var conversationLogs: Output<BotAliasConversationLogsArgs>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The name of the bot.
     */
    @JvmName("mdcajjcsjgbkqroj")
    public suspend fun botName(`value`: Output<String>) {
        this.botName = value
    }

    /**
     * @param value The version of the bot.
     */
    @JvmName("sgshejwjlfjspexi")
    public suspend fun botVersion(`value`: Output<String>) {
        this.botVersion = value
    }

    /**
     * @param value The settings that determine how Amazon Lex uses conversation logs for the alias. Attributes are documented under conversation_logs.
     */
    @JvmName("bjjjajngchxsqnhj")
    public suspend fun conversationLogs(`value`: Output<BotAliasConversationLogsArgs>) {
        this.conversationLogs = value
    }

    /**
     * @param value A description of the alias. Must be less than or equal to 200 characters in length.
     */
    @JvmName("ralxtrjrnuuaekpq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the alias. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("puodiqirwtkiefvk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the bot.
     */
    @JvmName("tqoxvvfqthylkgsi")
    public suspend fun botName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botName = mapped
    }

    /**
     * @param value The version of the bot.
     */
    @JvmName("gjcthjmpgvrgkshh")
    public suspend fun botVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botVersion = mapped
    }

    /**
     * @param value The settings that determine how Amazon Lex uses conversation logs for the alias. Attributes are documented under conversation_logs.
     */
    @JvmName("urpaqgacfuquxxjn")
    public suspend fun conversationLogs(`value`: BotAliasConversationLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conversationLogs = mapped
    }

    /**
     * @param argument The settings that determine how Amazon Lex uses conversation logs for the alias. Attributes are documented under conversation_logs.
     */
    @JvmName("ktojtudwtrqdtmqn")
    public suspend
    fun conversationLogs(argument: suspend BotAliasConversationLogsArgsBuilder.() -> Unit) {
        val toBeMapped = BotAliasConversationLogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.conversationLogs = mapped
    }

    /**
     * @param value A description of the alias. Must be less than or equal to 200 characters in length.
     */
    @JvmName("bmcpgnbmyvbiloir")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the alias. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("ktvdgbbqhskjbleg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BotAliasArgs = BotAliasArgs(
        botName = botName,
        botVersion = botVersion,
        conversationLogs = conversationLogs,
        description = description,
        name = name,
    )
}
