@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.IntentArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.IntentConclusionStatementArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentConclusionStatementArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentConfirmationPromptArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentConfirmationPromptArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentDialogCodeHookArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentDialogCodeHookArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentFollowUpPromptArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentFollowUpPromptArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentFulfillmentActivityArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentFulfillmentActivityArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentRejectionStatementArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentRejectionStatementArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentSlotArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentSlotArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Lex Intent resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.Intent;
 * import com.pulumi.aws.lex.IntentArgs;
 * import com.pulumi.aws.lex.inputs.IntentConfirmationPromptArgs;
 * import com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs;
 * import com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs;
 * import com.pulumi.aws.lex.inputs.IntentSlotArgs;
 * import com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderFlowersIntent = new Intent("orderFlowersIntent", IntentArgs.builder()
 *             .confirmationPrompt(IntentConfirmationPromptArgs.builder()
 *                 .maxAttempts(2)
 *                 .messages(IntentConfirmationPromptMessageArgs.builder()
 *                     .content("Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .createVersion(false)
 *             .description("Intent to order a bouquet of flowers for pick up")
 *             .fulfillmentActivity(IntentFulfillmentActivityArgs.builder()
 *                 .type("ReturnIntent")
 *                 .build())
 *             .name("OrderFlowers")
 *             .rejectionStatement(IntentRejectionStatementArgs.builder()
 *                 .messages(IntentRejectionStatementMessageArgs.builder()
 *                     .content("Okay, I will not place your order.")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .sampleUtterances(
 *                 "I would like to order some flowers",
 *                 "I would like to pick up flowers")
 *             .slots(
 *                 IntentSlotArgs.builder()
 *                     .description("The type of flowers to pick up")
 *                     .name("FlowerType")
 *                     .priority(1)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("FlowerTypes")
 *                     .slotTypeVersion("$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .message(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                     .build(),
 *                 IntentSlotArgs.builder()
 *                     .description("The date to pick up the flowers")
 *                     .name("PickupDate")
 *                     .priority(2)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("AMAZON.DATE")
 *                     .slotTypeVersion("$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .message(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                     .build(),
 *                 IntentSlotArgs.builder()
 *                     .description("The time to pick up the flowers")
 *                     .name("PickupTime")
 *                     .priority(3)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("AMAZON.TIME")
 *                     .slotTypeVersion("$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .message(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import intents using their name. For example:
 * ```sh
 *  $ pulumi import aws:lex/intent:Intent order_flowers_intent OrderFlowers
 * ```
 * @property conclusionStatement The statement that you want Amazon Lex to convey to the user
 * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
 * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
 * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
 * mutually exclusive. You can specify only one. Attributes are documented under statement.
 * @property confirmationPrompt Prompts the user to confirm the intent. This question should
 * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
 * or neither. Attributes are documented under prompt.
 * @property createVersion Determines if a new slot type version is created when the initial
 * resource is created and on each update. Defaults to `false`.
 * @property description A description of the intent. Must be less than or equal to 200 characters in length.
 * @property dialogCodeHook Specifies a Lambda function to invoke for each user input. You can
 * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
 * @property followUpPrompt Amazon Lex uses this prompt to solicit additional activity after
 * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
 * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
 * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
 * @property fulfillmentActivity Describes how the intent is fulfilled. For example, after a
 * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
 * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
 * @property name The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
 * @property parentIntentSignature A unique identifier for the built-in intent to base this
 * intent on. To find the signature for an intent, see
 * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
 * in the Alexa Skills Kit.
 * @property rejectionStatement When the user answers "no" to the question defined in
 * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
 * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
 * Attributes are documented under statement.
 * @property sampleUtterances An array of utterances (strings) that a user might say to signal
 * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
 * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
 * @property slots An list of intent slots. At runtime, Amazon Lex elicits required slot values
 * from the user using prompts defined in the slots. Attributes are documented under slot.
 */
public data class IntentArgs(
    public val conclusionStatement: Output<IntentConclusionStatementArgs>? = null,
    public val confirmationPrompt: Output<IntentConfirmationPromptArgs>? = null,
    public val createVersion: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val dialogCodeHook: Output<IntentDialogCodeHookArgs>? = null,
    public val followUpPrompt: Output<IntentFollowUpPromptArgs>? = null,
    public val fulfillmentActivity: Output<IntentFulfillmentActivityArgs>? = null,
    public val name: Output<String>? = null,
    public val parentIntentSignature: Output<String>? = null,
    public val rejectionStatement: Output<IntentRejectionStatementArgs>? = null,
    public val sampleUtterances: Output<List<String>>? = null,
    public val slots: Output<List<IntentSlotArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.IntentArgs> {
    override fun toJava(): com.pulumi.aws.lex.IntentArgs = com.pulumi.aws.lex.IntentArgs.builder()
        .conclusionStatement(
            conclusionStatement?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .confirmationPrompt(
            confirmationPrompt?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .createVersion(createVersion?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .dialogCodeHook(dialogCodeHook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .followUpPrompt(followUpPrompt?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .fulfillmentActivity(
            fulfillmentActivity?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .parentIntentSignature(parentIntentSignature?.applyValue({ args0 -> args0 }))
        .rejectionStatement(
            rejectionStatement?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .sampleUtterances(sampleUtterances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .slots(
            slots?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [IntentArgs].
 */
@PulumiTagMarker
public class IntentArgsBuilder internal constructor() {
    private var conclusionStatement: Output<IntentConclusionStatementArgs>? = null

    private var confirmationPrompt: Output<IntentConfirmationPromptArgs>? = null

    private var createVersion: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var dialogCodeHook: Output<IntentDialogCodeHookArgs>? = null

    private var followUpPrompt: Output<IntentFollowUpPromptArgs>? = null

    private var fulfillmentActivity: Output<IntentFulfillmentActivityArgs>? = null

    private var name: Output<String>? = null

    private var parentIntentSignature: Output<String>? = null

    private var rejectionStatement: Output<IntentRejectionStatementArgs>? = null

    private var sampleUtterances: Output<List<String>>? = null

    private var slots: Output<List<IntentSlotArgs>>? = null

    /**
     * @param value The statement that you want Amazon Lex to convey to the user
     * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
     * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
     * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
     * mutually exclusive. You can specify only one. Attributes are documented under statement.
     */
    @JvmName("otqdltufwxypcncd")
    public suspend fun conclusionStatement(`value`: Output<IntentConclusionStatementArgs>) {
        this.conclusionStatement = value
    }

    /**
     * @param value Prompts the user to confirm the intent. This question should
     * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
     * or neither. Attributes are documented under prompt.
     */
    @JvmName("bobefkmvqbhlhobs")
    public suspend fun confirmationPrompt(`value`: Output<IntentConfirmationPromptArgs>) {
        this.confirmationPrompt = value
    }

    /**
     * @param value Determines if a new slot type version is created when the initial
     * resource is created and on each update. Defaults to `false`.
     */
    @JvmName("jnahvsbqbmdlfxyh")
    public suspend fun createVersion(`value`: Output<Boolean>) {
        this.createVersion = value
    }

    /**
     * @param value A description of the intent. Must be less than or equal to 200 characters in length.
     */
    @JvmName("vkflqoavsvudmcmn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies a Lambda function to invoke for each user input. You can
     * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
     */
    @JvmName("puwllqshnkkvktaw")
    public suspend fun dialogCodeHook(`value`: Output<IntentDialogCodeHookArgs>) {
        this.dialogCodeHook = value
    }

    /**
     * @param value Amazon Lex uses this prompt to solicit additional activity after
     * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
     * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
     * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
     */
    @JvmName("thcjyleeyckylwci")
    public suspend fun followUpPrompt(`value`: Output<IntentFollowUpPromptArgs>) {
        this.followUpPrompt = value
    }

    /**
     * @param value Describes how the intent is fulfilled. For example, after a
     * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
     * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
     */
    @JvmName("vwkfjdietijghobg")
    public suspend fun fulfillmentActivity(`value`: Output<IntentFulfillmentActivityArgs>) {
        this.fulfillmentActivity = value
    }

    /**
     * @param value The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("krjskbxeydtbxdhd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A unique identifier for the built-in intent to base this
     * intent on. To find the signature for an intent, see
     * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
     * in the Alexa Skills Kit.
     */
    @JvmName("ieeteysghfdnoays")
    public suspend fun parentIntentSignature(`value`: Output<String>) {
        this.parentIntentSignature = value
    }

    /**
     * @param value When the user answers "no" to the question defined in
     * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
     * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
     * Attributes are documented under statement.
     */
    @JvmName("wdiyoatgwgarfqtn")
    public suspend fun rejectionStatement(`value`: Output<IntentRejectionStatementArgs>) {
        this.rejectionStatement = value
    }

    /**
     * @param value An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("sbbwncwprhlsgqpp")
    public suspend fun sampleUtterances(`value`: Output<List<String>>) {
        this.sampleUtterances = value
    }

    @JvmName("evytoglpjmqvlois")
    public suspend fun sampleUtterances(vararg values: Output<String>) {
        this.sampleUtterances = Output.all(values.asList())
    }

    /**
     * @param values An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("emnorpcdpxcqksqy")
    public suspend fun sampleUtterances(values: List<Output<String>>) {
        this.sampleUtterances = Output.all(values)
    }

    /**
     * @param value An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("crebcvqkihljnorg")
    public suspend fun slots(`value`: Output<List<IntentSlotArgs>>) {
        this.slots = value
    }

    @JvmName("qwjyektweksmdcbm")
    public suspend fun slots(vararg values: Output<IntentSlotArgs>) {
        this.slots = Output.all(values.asList())
    }

    /**
     * @param values An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("qijqvcnipbyifcvo")
    public suspend fun slots(values: List<Output<IntentSlotArgs>>) {
        this.slots = Output.all(values)
    }

    /**
     * @param value The statement that you want Amazon Lex to convey to the user
     * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
     * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
     * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
     * mutually exclusive. You can specify only one. Attributes are documented under statement.
     */
    @JvmName("gvesmpfvfceenwjs")
    public suspend fun conclusionStatement(`value`: IntentConclusionStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conclusionStatement = mapped
    }

    /**
     * @param argument The statement that you want Amazon Lex to convey to the user
     * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
     * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
     * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
     * mutually exclusive. You can specify only one. Attributes are documented under statement.
     */
    @JvmName("hxqwqihlbvoxrnda")
    public suspend
    fun conclusionStatement(argument: suspend IntentConclusionStatementArgsBuilder.() -> Unit) {
        val toBeMapped = IntentConclusionStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.conclusionStatement = mapped
    }

    /**
     * @param value Prompts the user to confirm the intent. This question should
     * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
     * or neither. Attributes are documented under prompt.
     */
    @JvmName("vqvmnpubfyryrsyb")
    public suspend fun confirmationPrompt(`value`: IntentConfirmationPromptArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationPrompt = mapped
    }

    /**
     * @param argument Prompts the user to confirm the intent. This question should
     * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
     * or neither. Attributes are documented under prompt.
     */
    @JvmName("yihqenetlftgynre")
    public suspend
    fun confirmationPrompt(argument: suspend IntentConfirmationPromptArgsBuilder.() -> Unit) {
        val toBeMapped = IntentConfirmationPromptArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.confirmationPrompt = mapped
    }

    /**
     * @param value Determines if a new slot type version is created when the initial
     * resource is created and on each update. Defaults to `false`.
     */
    @JvmName("ahoexdufpfspsnts")
    public suspend fun createVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createVersion = mapped
    }

    /**
     * @param value A description of the intent. Must be less than or equal to 200 characters in length.
     */
    @JvmName("fwglbxelltlsltpj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies a Lambda function to invoke for each user input. You can
     * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
     */
    @JvmName("mrurpwjbfmjyfhnr")
    public suspend fun dialogCodeHook(`value`: IntentDialogCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialogCodeHook = mapped
    }

    /**
     * @param argument Specifies a Lambda function to invoke for each user input. You can
     * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
     */
    @JvmName("ykkhrcaeuyoajwrh")
    public suspend fun dialogCodeHook(argument: suspend IntentDialogCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = IntentDialogCodeHookArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dialogCodeHook = mapped
    }

    /**
     * @param value Amazon Lex uses this prompt to solicit additional activity after
     * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
     * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
     * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
     */
    @JvmName("njecloduyxskmgww")
    public suspend fun followUpPrompt(`value`: IntentFollowUpPromptArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.followUpPrompt = mapped
    }

    /**
     * @param argument Amazon Lex uses this prompt to solicit additional activity after
     * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
     * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
     * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
     */
    @JvmName("hqxxupvmyvogusdi")
    public suspend fun followUpPrompt(argument: suspend IntentFollowUpPromptArgsBuilder.() -> Unit) {
        val toBeMapped = IntentFollowUpPromptArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.followUpPrompt = mapped
    }

    /**
     * @param value Describes how the intent is fulfilled. For example, after a
     * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
     * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
     */
    @JvmName("odlvatqgdmeeuwol")
    public suspend fun fulfillmentActivity(`value`: IntentFulfillmentActivityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfillmentActivity = mapped
    }

    /**
     * @param argument Describes how the intent is fulfilled. For example, after a
     * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
     * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
     */
    @JvmName("qhxdfqqeemiidwfl")
    public suspend
    fun fulfillmentActivity(argument: suspend IntentFulfillmentActivityArgsBuilder.() -> Unit) {
        val toBeMapped = IntentFulfillmentActivityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fulfillmentActivity = mapped
    }

    /**
     * @param value The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("qrnjellniydxicag")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A unique identifier for the built-in intent to base this
     * intent on. To find the signature for an intent, see
     * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
     * in the Alexa Skills Kit.
     */
    @JvmName("vpsfgvwcslyoifql")
    public suspend fun parentIntentSignature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentIntentSignature = mapped
    }

    /**
     * @param value When the user answers "no" to the question defined in
     * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
     * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
     * Attributes are documented under statement.
     */
    @JvmName("alocdehinmcxkowg")
    public suspend fun rejectionStatement(`value`: IntentRejectionStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectionStatement = mapped
    }

    /**
     * @param argument When the user answers "no" to the question defined in
     * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
     * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
     * Attributes are documented under statement.
     */
    @JvmName("oohvjemwuktpwgeg")
    public suspend
    fun rejectionStatement(argument: suspend IntentRejectionStatementArgsBuilder.() -> Unit) {
        val toBeMapped = IntentRejectionStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rejectionStatement = mapped
    }

    /**
     * @param value An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("wwhyriqpobyrgykx")
    public suspend fun sampleUtterances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param values An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("donbhrncirybvkue")
    public suspend fun sampleUtterances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param value An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("ixllfixoyxylckbk")
    public suspend fun slots(`value`: List<IntentSlotArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    /**
     * @param argument An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("nbctbhoqfbjhhfsx")
    public suspend fun slots(argument: List<suspend IntentSlotArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IntentSlotArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("oybdkxeendfvjhqm")
    public suspend fun slots(vararg argument: suspend IntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IntentSlotArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("ngbsbjqyvohnodsm")
    public suspend fun slots(argument: suspend IntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IntentSlotArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param values An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("texnrmfnohmhlnym")
    public suspend fun slots(vararg values: IntentSlotArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    internal fun build(): IntentArgs = IntentArgs(
        conclusionStatement = conclusionStatement,
        confirmationPrompt = confirmationPrompt,
        createVersion = createVersion,
        description = description,
        dialogCodeHook = dialogCodeHook,
        followUpPrompt = followUpPrompt,
        fulfillmentActivity = fulfillmentActivity,
        name = name,
        parentIntentSignature = parentIntentSignature,
        rejectionStatement = rejectionStatement,
        sampleUtterances = sampleUtterances,
        slots = slots,
    )
}
