@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.LexFunctions.getBotAliasPlain
import com.pulumi.aws.lex.LexFunctions.getBotPlain
import com.pulumi.aws.lex.LexFunctions.getIntentPlain
import com.pulumi.aws.lex.LexFunctions.getSlotTypePlain
import com.pulumi.aws.lex.kotlin.inputs.GetBotAliasPlainArgs
import com.pulumi.aws.lex.kotlin.inputs.GetBotAliasPlainArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.GetBotPlainArgs
import com.pulumi.aws.lex.kotlin.inputs.GetBotPlainArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.GetIntentPlainArgs
import com.pulumi.aws.lex.kotlin.inputs.GetIntentPlainArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.GetSlotTypePlainArgs
import com.pulumi.aws.lex.kotlin.inputs.GetSlotTypePlainArgsBuilder
import com.pulumi.aws.lex.kotlin.outputs.GetBotAliasResult
import com.pulumi.aws.lex.kotlin.outputs.GetBotResult
import com.pulumi.aws.lex.kotlin.outputs.GetIntentResult
import com.pulumi.aws.lex.kotlin.outputs.GetSlotTypeResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lex.kotlin.outputs.GetBotAliasResult.Companion.toKotlin as getBotAliasResultToKotlin
import com.pulumi.aws.lex.kotlin.outputs.GetBotResult.Companion.toKotlin as getBotResultToKotlin
import com.pulumi.aws.lex.kotlin.outputs.GetIntentResult.Companion.toKotlin as getIntentResultToKotlin
import com.pulumi.aws.lex.kotlin.outputs.GetSlotTypeResult.Companion.toKotlin as getSlotTypeResultToKotlin

public object LexFunctions {
    /**
     * Provides details about a specific Amazon Lex Bot.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lex.LexFunctions;
     * import com.pulumi.aws.lex.inputs.GetBotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var orderFlowersBot = LexFunctions.getBot(GetBotArgs.builder()
     *             .name("OrderFlowers")
     *             .version("$LATEST")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBot.
     * @return A collection of values returned by getBot.
     */
    public suspend fun getBot(argument: GetBotPlainArgs): GetBotResult =
        getBotResultToKotlin(getBotPlain(argument.toJava()).await())

    /**
     * @see [getBot].
     * @param name Name of the bot. The name is case sensitive.
     * @param version Version or alias of the bot.
     * @return A collection of values returned by getBot.
     */
    public suspend fun getBot(name: String, version: String? = null): GetBotResult {
        val argument = GetBotPlainArgs(
            name = name,
            version = version,
        )
        return getBotResultToKotlin(getBotPlain(argument.toJava()).await())
    }

    /**
     * @see [getBot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lex&#46;kotlin&#46;inputs&#46;GetBotPlainArgs].
     * @return A collection of values returned by getBot.
     */
    public suspend fun getBot(argument: suspend GetBotPlainArgsBuilder.() -> Unit): GetBotResult {
        val builder = GetBotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBotResultToKotlin(getBotPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Lex Bot Alias.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lex.LexFunctions;
     * import com.pulumi.aws.lex.inputs.GetBotAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var orderFlowersProd = LexFunctions.getBotAlias(GetBotAliasArgs.builder()
     *             .botName("OrderFlowers")
     *             .name("OrderFlowersProd")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBotAlias.
     * @return A collection of values returned by getBotAlias.
     */
    public suspend fun getBotAlias(argument: GetBotAliasPlainArgs): GetBotAliasResult =
        getBotAliasResultToKotlin(getBotAliasPlain(argument.toJava()).await())

    /**
     * @see [getBotAlias].
     * @param botName Name of the bot.
     * @param name Name of the bot alias. The name is case sensitive.
     * @return A collection of values returned by getBotAlias.
     */
    public suspend fun getBotAlias(botName: String, name: String): GetBotAliasResult {
        val argument = GetBotAliasPlainArgs(
            botName = botName,
            name = name,
        )
        return getBotAliasResultToKotlin(getBotAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getBotAlias].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lex&#46;kotlin&#46;inputs&#46;GetBotAliasPlainArgs].
     * @return A collection of values returned by getBotAlias.
     */
    public suspend fun getBotAlias(argument: suspend GetBotAliasPlainArgsBuilder.() -> Unit):
        GetBotAliasResult {
        val builder = GetBotAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBotAliasResultToKotlin(getBotAliasPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Lex Intent.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lex.LexFunctions;
     * import com.pulumi.aws.lex.inputs.GetIntentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var orderFlowers = LexFunctions.getIntent(GetIntentArgs.builder()
     *             .name("OrderFlowers")
     *             .version("$LATEST")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getIntent.
     * @return A collection of values returned by getIntent.
     */
    public suspend fun getIntent(argument: GetIntentPlainArgs): GetIntentResult =
        getIntentResultToKotlin(getIntentPlain(argument.toJava()).await())

    /**
     * @see [getIntent].
     * @param name Name of the intent. The name is case sensitive.
     * @param version Version of the intent.
     * @return A collection of values returned by getIntent.
     */
    public suspend fun getIntent(name: String, version: String? = null): GetIntentResult {
        val argument = GetIntentPlainArgs(
            name = name,
            version = version,
        )
        return getIntentResultToKotlin(getIntentPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntent].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lex&#46;kotlin&#46;inputs&#46;GetIntentPlainArgs].
     * @return A collection of values returned by getIntent.
     */
    public suspend fun getIntent(argument: suspend GetIntentPlainArgsBuilder.() -> Unit):
        GetIntentResult {
        val builder = GetIntentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntentResultToKotlin(getIntentPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Lex Slot Type.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lex.LexFunctions;
     * import com.pulumi.aws.lex.inputs.GetSlotTypeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var flowerTypes = LexFunctions.getSlotType(GetSlotTypeArgs.builder()
     *             .name("FlowerTypes")
     *             .version("1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSlotType.
     * @return A collection of values returned by getSlotType.
     */
    public suspend fun getSlotType(argument: GetSlotTypePlainArgs): GetSlotTypeResult =
        getSlotTypeResultToKotlin(getSlotTypePlain(argument.toJava()).await())

    /**
     * @see [getSlotType].
     * @param name Name of the slot type. The name is case sensitive.
     * @param version Version of the slot type.
     * @return A collection of values returned by getSlotType.
     */
    public suspend fun getSlotType(name: String, version: String? = null): GetSlotTypeResult {
        val argument = GetSlotTypePlainArgs(
            name = name,
            version = version,
        )
        return getSlotTypeResultToKotlin(getSlotTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getSlotType].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lex&#46;kotlin&#46;inputs&#46;GetSlotTypePlainArgs].
     * @return A collection of values returned by getSlotType.
     */
    public suspend fun getSlotType(argument: suspend GetSlotTypePlainArgsBuilder.() -> Unit):
        GetSlotTypeResult {
        val builder = GetSlotTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSlotTypeResultToKotlin(getSlotTypePlain(builtArgument.toJava()).await())
    }
}
