@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.SlotTypeArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.SlotTypeEnumerationValueArgs
import com.pulumi.aws.lex.kotlin.inputs.SlotTypeEnumerationValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Lex Slot Type resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.SlotType;
 * import com.pulumi.aws.lex.SlotTypeArgs;
 * import com.pulumi.aws.lex.inputs.SlotTypeEnumerationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var flowerTypes = new SlotType("flowerTypes", SlotTypeArgs.builder()
 *             .createVersion(true)
 *             .description("Types of flowers to order")
 *             .enumerationValues(
 *                 SlotTypeEnumerationValueArgs.builder()
 *                     .synonyms(
 *                         "Lirium",
 *                         "Martagon")
 *                     .value("lilies")
 *                     .build(),
 *                 SlotTypeEnumerationValueArgs.builder()
 *                     .synonyms(
 *                         "Eduardoregelia",
 *                         "Podonix")
 *                     .value("tulips")
 *                     .build())
 *             .name("FlowerTypes")
 *             .valueSelectionStrategy("ORIGINAL_VALUE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import slot types using their name. For example:
 * ```sh
 *  $ pulumi import aws:lex/slotType:SlotType flower_types FlowerTypes
 * ```
 * @property createVersion Determines if a new slot type version is created when the initial resource is created and on each
 * update. Defaults to `false`.
 * @property description A description of the slot type. Must be less than or equal to 200 characters in length.
 * @property enumerationValues A list of EnumerationValue objects that defines the values that
 * the slot type can take. Each value can have a list of synonyms, which are additional values that help
 * train the machine learning model about the values that it resolves for a slot. Attributes are
 * documented under enumeration_value.
 * @property name The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
 * @property valueSelectionStrategy Determines the slot resolution strategy that Amazon Lex
 * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
 * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
 * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
 */
public data class SlotTypeArgs(
    public val createVersion: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val enumerationValues: Output<List<SlotTypeEnumerationValueArgs>>? = null,
    public val name: Output<String>? = null,
    public val valueSelectionStrategy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.SlotTypeArgs> {
    override fun toJava(): com.pulumi.aws.lex.SlotTypeArgs = com.pulumi.aws.lex.SlotTypeArgs.builder()
        .createVersion(createVersion?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .enumerationValues(
            enumerationValues?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .valueSelectionStrategy(valueSelectionStrategy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlotTypeArgs].
 */
@PulumiTagMarker
public class SlotTypeArgsBuilder internal constructor() {
    private var createVersion: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var enumerationValues: Output<List<SlotTypeEnumerationValueArgs>>? = null

    private var name: Output<String>? = null

    private var valueSelectionStrategy: Output<String>? = null

    /**
     * @param value Determines if a new slot type version is created when the initial resource is created and on each
     * update. Defaults to `false`.
     */
    @JvmName("olhwxldqtaeujtvh")
    public suspend fun createVersion(`value`: Output<Boolean>) {
        this.createVersion = value
    }

    /**
     * @param value A description of the slot type. Must be less than or equal to 200 characters in length.
     */
    @JvmName("hikfvfgdquefidrb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    @JvmName("vokvcgwqcsqnowkm")
    public suspend fun enumerationValues(`value`: Output<List<SlotTypeEnumerationValueArgs>>) {
        this.enumerationValues = value
    }

    @JvmName("lacrqvwyfcodjqyx")
    public suspend fun enumerationValues(vararg values: Output<SlotTypeEnumerationValueArgs>) {
        this.enumerationValues = Output.all(values.asList())
    }

    /**
     * @param values A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    @JvmName("nvrfechplxqrkkon")
    public suspend fun enumerationValues(values: List<Output<SlotTypeEnumerationValueArgs>>) {
        this.enumerationValues = Output.all(values)
    }

    /**
     * @param value The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("xfihwxklbgawowct")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Determines the slot resolution strategy that Amazon Lex
     * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
     * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
     * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
     */
    @JvmName("xrtclpqctwltntbh")
    public suspend fun valueSelectionStrategy(`value`: Output<String>) {
        this.valueSelectionStrategy = value
    }

    /**
     * @param value Determines if a new slot type version is created when the initial resource is created and on each
     * update. Defaults to `false`.
     */
    @JvmName("ksunotxptvyplwtg")
    public suspend fun createVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createVersion = mapped
    }

    /**
     * @param value A description of the slot type. Must be less than or equal to 200 characters in length.
     */
    @JvmName("aklwclwfgwhqivde")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    @JvmName("ksyxjkvprvgfmytf")
    public suspend fun enumerationValues(`value`: List<SlotTypeEnumerationValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enumerationValues = mapped
    }

    /**
     * @param argument A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    @JvmName("punixwbvqqufkruj")
    public suspend
    fun enumerationValues(argument: List<suspend SlotTypeEnumerationValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SlotTypeEnumerationValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.enumerationValues = mapped
    }

    /**
     * @param argument A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    @JvmName("wctimqtlrnyndkuj")
    public suspend fun enumerationValues(
        vararg
        argument: suspend SlotTypeEnumerationValueArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SlotTypeEnumerationValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.enumerationValues = mapped
    }

    /**
     * @param argument A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    @JvmName("uhuftgdhhcsfvhlw")
    public suspend
    fun enumerationValues(argument: suspend SlotTypeEnumerationValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SlotTypeEnumerationValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.enumerationValues = mapped
    }

    /**
     * @param values A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    @JvmName("wqvgalphccqoeaxl")
    public suspend fun enumerationValues(vararg values: SlotTypeEnumerationValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enumerationValues = mapped
    }

    /**
     * @param value The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("ftfnwcpwpnkvvyir")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Determines the slot resolution strategy that Amazon Lex
     * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
     * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
     * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
     */
    @JvmName("ggryxgswlyeiswqh")
    public suspend fun valueSelectionStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueSelectionStrategy = mapped
    }

    internal fun build(): SlotTypeArgs = SlotTypeArgs(
        createVersion = createVersion,
        description = description,
        enumerationValues = enumerationValues,
        name = name,
        valueSelectionStrategy = valueSelectionStrategy,
    )
}
