@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.V2modelsBotArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotDataPrivacyArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotDataPrivacyArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotMemberArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotMemberArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotTimeoutsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lex V2 Models Bot.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBot;
 * import com.pulumi.aws.lex.V2modelsBotArgs;
 * import com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsBot("example", V2modelsBotArgs.builder()
 *             .dataPrivacies(V2modelsBotDataPrivacyArgs.builder()
 *                 .childDirected("boolean")
 *                 .build())
 *             .idleSessionTtlInSeconds(10)
 *             .roleArn("bot_example_arn")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Bot using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:lex/v2modelsBot:V2modelsBot example bot-id-12345678
 * ```
 * @property dataPrivacies Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
 * @property description Description of the bot. It appears in lists to help you identify a particular bot.
 * @property idleSessionTtlInSeconds Time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
 * @property members List of bot members in a network to be created. See `bot_members`.
 * @property name Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
 * @property roleArn ARN of an IAM role that has permission to access the bot.
 * The following arguments are optional:
 * @property tags List of tags to add to the bot. You can only add tags when you create a bot.
 * @property testBotAliasTags List of tags to add to the test alias for a bot. You can only add tags when you create a bot.
 * @property timeouts
 * @property type Type of a bot to create. Possible values are `"Bot"` and `"BotNetwork"`.
 */
public data class V2modelsBotArgs(
    public val dataPrivacies: Output<List<V2modelsBotDataPrivacyArgs>>? = null,
    public val description: Output<String>? = null,
    public val idleSessionTtlInSeconds: Output<Int>? = null,
    public val members: Output<List<V2modelsBotMemberArgs>>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val testBotAliasTags: Output<Map<String, String>>? = null,
    public val timeouts: Output<V2modelsBotTimeoutsArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.V2modelsBotArgs> {
    override fun toJava(): com.pulumi.aws.lex.V2modelsBotArgs =
        com.pulumi.aws.lex.V2modelsBotArgs.builder()
            .dataPrivacies(
                dataPrivacies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .idleSessionTtlInSeconds(idleSessionTtlInSeconds?.applyValue({ args0 -> args0 }))
            .members(
                members?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .testBotAliasTags(
                testBotAliasTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsBotArgs].
 */
@PulumiTagMarker
public class V2modelsBotArgsBuilder internal constructor() {
    private var dataPrivacies: Output<List<V2modelsBotDataPrivacyArgs>>? = null

    private var description: Output<String>? = null

    private var idleSessionTtlInSeconds: Output<Int>? = null

    private var members: Output<List<V2modelsBotMemberArgs>>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var testBotAliasTags: Output<Map<String, String>>? = null

    private var timeouts: Output<V2modelsBotTimeoutsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    @JvmName("tqiepgpikgvkiudn")
    public suspend fun dataPrivacies(`value`: Output<List<V2modelsBotDataPrivacyArgs>>) {
        this.dataPrivacies = value
    }

    @JvmName("fwkjhhgqhahjwkaa")
    public suspend fun dataPrivacies(vararg values: Output<V2modelsBotDataPrivacyArgs>) {
        this.dataPrivacies = Output.all(values.asList())
    }

    /**
     * @param values Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    @JvmName("lfafgvvnuhepsyuh")
    public suspend fun dataPrivacies(values: List<Output<V2modelsBotDataPrivacyArgs>>) {
        this.dataPrivacies = Output.all(values)
    }

    /**
     * @param value Description of the bot. It appears in lists to help you identify a particular bot.
     */
    @JvmName("bconolwdtoaeorhx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    @JvmName("yruqweklohdrvvjf")
    public suspend fun idleSessionTtlInSeconds(`value`: Output<Int>) {
        this.idleSessionTtlInSeconds = value
    }

    /**
     * @param value List of bot members in a network to be created. See `bot_members`.
     */
    @JvmName("hrtgbhohaeuyenwp")
    public suspend fun members(`value`: Output<List<V2modelsBotMemberArgs>>) {
        this.members = value
    }

    @JvmName("brygwoaxvsfrjddy")
    public suspend fun members(vararg values: Output<V2modelsBotMemberArgs>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values List of bot members in a network to be created. See `bot_members`.
     */
    @JvmName("udsajjbcgoccugxt")
    public suspend fun members(values: List<Output<V2modelsBotMemberArgs>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
     */
    @JvmName("wmqfhyahbjysbyqt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of an IAM role that has permission to access the bot.
     * The following arguments are optional:
     */
    @JvmName("gfbjwrlywbckfieu")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value List of tags to add to the bot. You can only add tags when you create a bot.
     */
    @JvmName("soltemihkmmdtlqg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of tags to add to the test alias for a bot. You can only add tags when you create a bot.
     */
    @JvmName("qxisqufpxvrxsdkl")
    public suspend fun testBotAliasTags(`value`: Output<Map<String, String>>) {
        this.testBotAliasTags = value
    }

    /**
     * @param value
     */
    @JvmName("gctgqrxiekwoaoob")
    public suspend fun timeouts(`value`: Output<V2modelsBotTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Type of a bot to create. Possible values are `"Bot"` and `"BotNetwork"`.
     */
    @JvmName("cgglvfklksmdtvyi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    @JvmName("oykmkutaroinnjyc")
    public suspend fun dataPrivacies(`value`: List<V2modelsBotDataPrivacyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPrivacies = mapped
    }

    /**
     * @param argument Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    @JvmName("qakhittavxpucbnq")
    public suspend
    fun dataPrivacies(argument: List<suspend V2modelsBotDataPrivacyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsBotDataPrivacyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPrivacies = mapped
    }

    /**
     * @param argument Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    @JvmName("nliviyjoadrtnkaq")
    public suspend fun dataPrivacies(
        vararg
        argument: suspend V2modelsBotDataPrivacyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            V2modelsBotDataPrivacyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPrivacies = mapped
    }

    /**
     * @param argument Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    @JvmName("difjfjmqmipnfgcs")
    public suspend fun dataPrivacies(argument: suspend V2modelsBotDataPrivacyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(V2modelsBotDataPrivacyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataPrivacies = mapped
    }

    /**
     * @param values Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    @JvmName("jseddkirgxskvsod")
    public suspend fun dataPrivacies(vararg values: V2modelsBotDataPrivacyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPrivacies = mapped
    }

    /**
     * @param value Description of the bot. It appears in lists to help you identify a particular bot.
     */
    @JvmName("scddwrscephiueyl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    @JvmName("jfrlhlavvqsrscgf")
    public suspend fun idleSessionTtlInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleSessionTtlInSeconds = mapped
    }

    /**
     * @param value List of bot members in a network to be created. See `bot_members`.
     */
    @JvmName("hpevbmkqfwdljhke")
    public suspend fun members(`value`: List<V2modelsBotMemberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param argument List of bot members in a network to be created. See `bot_members`.
     */
    @JvmName("jwdyqxofyorpwcgb")
    public suspend fun members(argument: List<suspend V2modelsBotMemberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsBotMemberArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument List of bot members in a network to be created. See `bot_members`.
     */
    @JvmName("gwjeoswetfcftwwi")
    public suspend fun members(vararg argument: suspend V2modelsBotMemberArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsBotMemberArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument List of bot members in a network to be created. See `bot_members`.
     */
    @JvmName("pxvjuycwvucxifia")
    public suspend fun members(argument: suspend V2modelsBotMemberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(V2modelsBotMemberArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param values List of bot members in a network to be created. See `bot_members`.
     */
    @JvmName("aeorjpaubicyejwx")
    public suspend fun members(vararg values: V2modelsBotMemberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param value Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
     */
    @JvmName("cmtuuqchugxwjrqe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ARN of an IAM role that has permission to access the bot.
     * The following arguments are optional:
     */
    @JvmName("jyelbhtnbmfvobkv")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value List of tags to add to the bot. You can only add tags when you create a bot.
     */
    @JvmName("vpvphmlgbtexlorl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values List of tags to add to the bot. You can only add tags when you create a bot.
     */
    @JvmName("enkacrxbborttcye")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of tags to add to the test alias for a bot. You can only add tags when you create a bot.
     */
    @JvmName("lluqeyusofxqsxfe")
    public suspend fun testBotAliasTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBotAliasTags = mapped
    }

    /**
     * @param values List of tags to add to the test alias for a bot. You can only add tags when you create a bot.
     */
    @JvmName("uytnhbnoqacxuuwm")
    public fun testBotAliasTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testBotAliasTags = mapped
    }

    /**
     * @param value
     */
    @JvmName("hcskrycicawmepki")
    public suspend fun timeouts(`value`: V2modelsBotTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hbklnvtqiumnohwq")
    public suspend fun timeouts(argument: suspend V2modelsBotTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsBotTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Type of a bot to create. Possible values are `"Bot"` and `"BotNetwork"`.
     */
    @JvmName("vvaqeahcobqshtuj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): V2modelsBotArgs = V2modelsBotArgs(
        dataPrivacies = dataPrivacies,
        description = description,
        idleSessionTtlInSeconds = idleSessionTtlInSeconds,
        members = members,
        name = name,
        roleArn = roleArn,
        tags = tags,
        testBotAliasTags = testBotAliasTags,
        timeouts = timeouts,
        type = type,
    )
}
