@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotLocaleTimeouts
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotLocaleVoiceSettings
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotLocaleTimeouts.Companion.toKotlin as v2modelsBotLocaleTimeoutsToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotLocaleVoiceSettings.Companion.toKotlin as v2modelsBotLocaleVoiceSettingsToKotlin

/**
 * Builder for [V2modelsBotLocale].
 */
@PulumiTagMarker
public class V2modelsBotLocaleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V2modelsBotLocaleArgs = V2modelsBotLocaleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V2modelsBotLocaleArgsBuilder.() -> Unit) {
        val builder = V2modelsBotLocaleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): V2modelsBotLocale {
        val builtJavaResource = com.pulumi.aws.lex.V2modelsBotLocale(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V2modelsBotLocale(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lex V2 Models Bot Locale.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBotLocale;
 * import com.pulumi.aws.lex.V2modelsBotLocaleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsBotLocale("example", V2modelsBotLocaleArgs.builder()
 *             .botId(aws_lexv2models_bot.example().id())
 *             .botVersion("DRAFT")
 *             .localeId("en_US")
 *             .nLuIntentConfidenceThreshold(0.7)
 *             .build());
 *     }
 * }
 * ```
 * ### Voice Settings
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBotLocale;
 * import com.pulumi.aws.lex.V2modelsBotLocaleArgs;
 * import com.pulumi.aws.lex.inputs.V2modelsBotLocaleVoiceSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsBotLocale("example", V2modelsBotLocaleArgs.builder()
 *             .botId(aws_lexv2models_bot.example().id())
 *             .botVersion("DRAFT")
 *             .localeId("en_US")
 *             .nLuIntentConfidenceThreshold(0.7)
 *             .voiceSettings(V2modelsBotLocaleVoiceSettingsArgs.builder()
 *                 .voiceId("Kendra")
 *                 .engine("standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Bot Locale using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:lex/v2modelsBotLocale:V2modelsBotLocale example bot_locale-id-12345678
 * ```
 *
 */
public class V2modelsBotLocale internal constructor(
    override val javaResource: com.pulumi.aws.lex.V2modelsBotLocale,
) : KotlinCustomResource(javaResource, V2modelsBotLocaleMapper) {
    /**
     * Identifier of the bot to create the locale for.
     */
    public val botId: Output<String>
        get() = javaResource.botId().applyValue({ args0 -> args0 })

    /**
     * Version of the bot to create the locale for. This can only be the draft version of the bot.
     */
    public val botVersion: Output<String>
        get() = javaResource.botVersion().applyValue({ args0 -> args0 })

    /**
     * Description of the bot locale. Use this to help identify the bot locale in lists.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
     */
    public val localeId: Output<String>
        get() = javaResource.localeId().applyValue({ args0 -> args0 })

    /**
     * Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents.
     * The following arguments are optional:
     */
    public val nLuIntentConfidenceThreshold: Output<Double>
        get() = javaResource.nLuIntentConfidenceThreshold().applyValue({ args0 -> args0 })

    /**
     * Specified locale name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val timeouts: Output<V2modelsBotLocaleTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2modelsBotLocaleTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. See `voice_settings`.
     */
    public val voiceSettings: Output<V2modelsBotLocaleVoiceSettings>?
        get() = javaResource.voiceSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsBotLocaleVoiceSettingsToKotlin(args0) })
            }).orElse(null)
        })
}

public object V2modelsBotLocaleMapper : ResourceMapper<V2modelsBotLocale> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.V2modelsBotLocale::class == javaResource::class

    override fun map(javaResource: Resource): V2modelsBotLocale = V2modelsBotLocale(
        javaResource as
            com.pulumi.aws.lex.V2modelsBotLocale,
    )
}

/**
 * @see [V2modelsBotLocale].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V2modelsBotLocale].
 */
public suspend fun v2modelsBotLocale(
    name: String,
    block: suspend V2modelsBotLocaleResourceBuilder.() -> Unit,
): V2modelsBotLocale {
    val builder = V2modelsBotLocaleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V2modelsBotLocale].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v2modelsBotLocale(name: String): V2modelsBotLocale {
    val builder = V2modelsBotLocaleResourceBuilder()
    builder.name(name)
    return builder.build()
}
