@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.V2modelsBotLocaleArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotLocaleTimeoutsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotLocaleTimeoutsArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotLocaleVoiceSettingsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotLocaleVoiceSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lex V2 Models Bot Locale.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBotLocale;
 * import com.pulumi.aws.lex.V2modelsBotLocaleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsBotLocale("example", V2modelsBotLocaleArgs.builder()
 *             .botId(aws_lexv2models_bot.example().id())
 *             .botVersion("DRAFT")
 *             .localeId("en_US")
 *             .nLuIntentConfidenceThreshold(0.7)
 *             .build());
 *     }
 * }
 * ```
 * ### Voice Settings
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBotLocale;
 * import com.pulumi.aws.lex.V2modelsBotLocaleArgs;
 * import com.pulumi.aws.lex.inputs.V2modelsBotLocaleVoiceSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsBotLocale("example", V2modelsBotLocaleArgs.builder()
 *             .botId(aws_lexv2models_bot.example().id())
 *             .botVersion("DRAFT")
 *             .localeId("en_US")
 *             .nLuIntentConfidenceThreshold(0.7)
 *             .voiceSettings(V2modelsBotLocaleVoiceSettingsArgs.builder()
 *                 .voiceId("Kendra")
 *                 .engine("standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Bot Locale using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:lex/v2modelsBotLocale:V2modelsBotLocale example bot_locale-id-12345678
 * ```
 * @property botId Identifier of the bot to create the locale for.
 * @property botVersion Version of the bot to create the locale for. This can only be the draft version of the bot.
 * @property description Description of the bot locale. Use this to help identify the bot locale in lists.
 * @property localeId Identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
 * @property nLuIntentConfidenceThreshold Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents.
 * The following arguments are optional:
 * @property name Specified locale name.
 * @property timeouts
 * @property voiceSettings Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. See `voice_settings`.
 */
public data class V2modelsBotLocaleArgs(
    public val botId: Output<String>? = null,
    public val botVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val localeId: Output<String>? = null,
    public val nLuIntentConfidenceThreshold: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val timeouts: Output<V2modelsBotLocaleTimeoutsArgs>? = null,
    public val voiceSettings: Output<V2modelsBotLocaleVoiceSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.V2modelsBotLocaleArgs> {
    override fun toJava(): com.pulumi.aws.lex.V2modelsBotLocaleArgs =
        com.pulumi.aws.lex.V2modelsBotLocaleArgs.builder()
            .botId(botId?.applyValue({ args0 -> args0 }))
            .botVersion(botVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .localeId(localeId?.applyValue({ args0 -> args0 }))
            .nLuIntentConfidenceThreshold(nLuIntentConfidenceThreshold?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .voiceSettings(voiceSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsBotLocaleArgs].
 */
@PulumiTagMarker
public class V2modelsBotLocaleArgsBuilder internal constructor() {
    private var botId: Output<String>? = null

    private var botVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var localeId: Output<String>? = null

    private var nLuIntentConfidenceThreshold: Output<Double>? = null

    private var name: Output<String>? = null

    private var timeouts: Output<V2modelsBotLocaleTimeoutsArgs>? = null

    private var voiceSettings: Output<V2modelsBotLocaleVoiceSettingsArgs>? = null

    /**
     * @param value Identifier of the bot to create the locale for.
     */
    @JvmName("yjxdgsfgqiqolaqu")
    public suspend fun botId(`value`: Output<String>) {
        this.botId = value
    }

    /**
     * @param value Version of the bot to create the locale for. This can only be the draft version of the bot.
     */
    @JvmName("moqawbtoqpewefqx")
    public suspend fun botVersion(`value`: Output<String>) {
        this.botVersion = value
    }

    /**
     * @param value Description of the bot locale. Use this to help identify the bot locale in lists.
     */
    @JvmName("opfdaltoufgwwnei")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
     */
    @JvmName("bcqmxnagpjrvtlnm")
    public suspend fun localeId(`value`: Output<String>) {
        this.localeId = value
    }

    /**
     * @param value Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents.
     * The following arguments are optional:
     */
    @JvmName("goyhfhojewsainev")
    public suspend fun nLuIntentConfidenceThreshold(`value`: Output<Double>) {
        this.nLuIntentConfidenceThreshold = value
    }

    /**
     * @param value Specified locale name.
     */
    @JvmName("bkxsyovjylrodibc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("lrlrylxetlphgoiv")
    public suspend fun timeouts(`value`: Output<V2modelsBotLocaleTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. See `voice_settings`.
     */
    @JvmName("trqcoklgahwrboml")
    public suspend fun voiceSettings(`value`: Output<V2modelsBotLocaleVoiceSettingsArgs>) {
        this.voiceSettings = value
    }

    /**
     * @param value Identifier of the bot to create the locale for.
     */
    @JvmName("uarhobgtympqknhy")
    public suspend fun botId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botId = mapped
    }

    /**
     * @param value Version of the bot to create the locale for. This can only be the draft version of the bot.
     */
    @JvmName("dbgmjtmorewaufus")
    public suspend fun botVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botVersion = mapped
    }

    /**
     * @param value Description of the bot locale. Use this to help identify the bot locale in lists.
     */
    @JvmName("hspmakullcatbiwh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
     */
    @JvmName("rwhqqvcxklpplgyj")
    public suspend fun localeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localeId = mapped
    }

    /**
     * @param value Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents.
     * The following arguments are optional:
     */
    @JvmName("uymqjuircgmuqcme")
    public suspend fun nLuIntentConfidenceThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nLuIntentConfidenceThreshold = mapped
    }

    /**
     * @param value Specified locale name.
     */
    @JvmName("eeysssrweehkrpkp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("okucbvjxcgypscob")
    public suspend fun timeouts(`value`: V2modelsBotLocaleTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jgyhjwfhkxddcbyp")
    public suspend fun timeouts(argument: suspend V2modelsBotLocaleTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsBotLocaleTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. See `voice_settings`.
     */
    @JvmName("frcecrmdpoormtou")
    public suspend fun voiceSettings(`value`: V2modelsBotLocaleVoiceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceSettings = mapped
    }

    /**
     * @param argument Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. See `voice_settings`.
     */
    @JvmName("fcfidvjsilbygoqr")
    public suspend
    fun voiceSettings(argument: suspend V2modelsBotLocaleVoiceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsBotLocaleVoiceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.voiceSettings = mapped
    }

    internal fun build(): V2modelsBotLocaleArgs = V2modelsBotLocaleArgs(
        botId = botId,
        botVersion = botVersion,
        description = description,
        localeId = localeId,
        nLuIntentConfidenceThreshold = nLuIntentConfidenceThreshold,
        name = name,
        timeouts = timeouts,
        voiceSettings = voiceSettings,
    )
}
