@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotVersionLocaleSpecification
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotVersionTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotVersionLocaleSpecification.Companion.toKotlin as v2modelsBotVersionLocaleSpecificationToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotVersionTimeouts.Companion.toKotlin as v2modelsBotVersionTimeoutsToKotlin

/**
 * Builder for [V2modelsBotVersion].
 */
@PulumiTagMarker
public class V2modelsBotVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V2modelsBotVersionArgs = V2modelsBotVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V2modelsBotVersionArgsBuilder.() -> Unit) {
        val builder = V2modelsBotVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): V2modelsBotVersion {
        val builtJavaResource = com.pulumi.aws.lex.V2modelsBotVersion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V2modelsBotVersion(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lex V2 Models Bot Version.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBotVersion;
 * import com.pulumi.aws.lex.V2modelsBotVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new V2modelsBotVersion("test", V2modelsBotVersionArgs.builder()
 *             .botId(aws_lexv2models.test().id())
 *             .localeDetails(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Bot Version using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:lex/v2modelsBotVersion:V2modelsBotVersion example bot_version-id-12345678
 * ```
 *
 */
public class V2modelsBotVersion internal constructor(
    override val javaResource: com.pulumi.aws.lex.V2modelsBotVersion,
) : KotlinCustomResource(javaResource, V2modelsBotVersionMapper) {
    /**
     * Idientifier of the bot to create the version for.
     */
    public val botId: Output<String>
        get() = javaResource.botId().applyValue({ args0 -> args0 })

    public val botVersion: Output<String>
        get() = javaResource.botVersion().applyValue({ args0 -> args0 })

    /**
     * A description of the version. Use the description to help identify the version in lists.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val localeSpecification: Output<Map<String, V2modelsBotVersionLocaleSpecification>>
        get() = javaResource.localeSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        v2modelsBotVersionLocaleSpecificationToKotlin(args0)
                    }),
                )
            }).toMap()
        })

    public val timeouts: Output<V2modelsBotVersionTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2modelsBotVersionTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object V2modelsBotVersionMapper : ResourceMapper<V2modelsBotVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.V2modelsBotVersion::class == javaResource::class

    override fun map(javaResource: Resource): V2modelsBotVersion = V2modelsBotVersion(
        javaResource as
            com.pulumi.aws.lex.V2modelsBotVersion,
    )
}

/**
 * @see [V2modelsBotVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V2modelsBotVersion].
 */
public suspend fun v2modelsBotVersion(
    name: String,
    block: suspend V2modelsBotVersionResourceBuilder.() -> Unit,
): V2modelsBotVersion {
    val builder = V2modelsBotVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V2modelsBotVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v2modelsBotVersion(name: String): V2modelsBotVersion {
    val builder = V2modelsBotVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
