@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.V2modelsBotVersionArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionLocaleSpecificationArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionLocaleSpecificationArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionTimeoutsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lex V2 Models Bot Version.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBotVersion;
 * import com.pulumi.aws.lex.V2modelsBotVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new V2modelsBotVersion("test", V2modelsBotVersionArgs.builder()
 *             .botId(aws_lexv2models.test().id())
 *             .localeDetails(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Bot Version using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:lex/v2modelsBotVersion:V2modelsBotVersion example bot_version-id-12345678
 * ```
 * @property botId Idientifier of the bot to create the version for.
 * @property botVersion
 * @property description A description of the version. Use the description to help identify the version in lists.
 * @property localeSpecification
 * @property timeouts
 */
public data class V2modelsBotVersionArgs(
    public val botId: Output<String>? = null,
    public val botVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val localeSpecification: Output<Map<String, V2modelsBotVersionLocaleSpecificationArgs>>? =
        null,
    public val timeouts: Output<V2modelsBotVersionTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.V2modelsBotVersionArgs> {
    override fun toJava(): com.pulumi.aws.lex.V2modelsBotVersionArgs =
        com.pulumi.aws.lex.V2modelsBotVersionArgs.builder()
            .botId(botId?.applyValue({ args0 -> args0 }))
            .botVersion(botVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .localeSpecification(
                localeSpecification?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsBotVersionArgs].
 */
@PulumiTagMarker
public class V2modelsBotVersionArgsBuilder internal constructor() {
    private var botId: Output<String>? = null

    private var botVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var localeSpecification: Output<Map<String, V2modelsBotVersionLocaleSpecificationArgs>>? =
        null

    private var timeouts: Output<V2modelsBotVersionTimeoutsArgs>? = null

    /**
     * @param value Idientifier of the bot to create the version for.
     */
    @JvmName("yrswceujhdiubtyr")
    public suspend fun botId(`value`: Output<String>) {
        this.botId = value
    }

    /**
     * @param value
     */
    @JvmName("bdwjpknfycjkmley")
    public suspend fun botVersion(`value`: Output<String>) {
        this.botVersion = value
    }

    /**
     * @param value A description of the version. Use the description to help identify the version in lists.
     */
    @JvmName("pofvdqhkcxexiiof")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("fhpvxhbsbubxxyev")
    public suspend
    fun localeSpecification(`value`: Output<Map<String, V2modelsBotVersionLocaleSpecificationArgs>>) {
        this.localeSpecification = value
    }

    /**
     * @param value
     */
    @JvmName("mealptpcxpnfolnp")
    public suspend fun timeouts(`value`: Output<V2modelsBotVersionTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Idientifier of the bot to create the version for.
     */
    @JvmName("nrwiggrepfyrwyji")
    public suspend fun botId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botId = mapped
    }

    /**
     * @param value
     */
    @JvmName("uycaaqtvjgomfvte")
    public suspend fun botVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botVersion = mapped
    }

    /**
     * @param value A description of the version. Use the description to help identify the version in lists.
     */
    @JvmName("ypnfrditnpggoayb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("krwshclukulgxfwr")
    public suspend
    fun localeSpecification(`value`: Map<String, V2modelsBotVersionLocaleSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localeSpecification = mapped
    }

    /**
     * @param argument
     */
    @JvmName("erjypxnnaweadcmu")
    public suspend fun localeSpecification(
        vararg
        argument: Pair<String, suspend V2modelsBotVersionLocaleSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                V2modelsBotVersionLocaleSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.localeSpecification = mapped
    }

    /**
     * @param values
     */
    @JvmName("kuoaaxocekfgktkm")
    public fun localeSpecification(
        vararg
        values: Pair<String, V2modelsBotVersionLocaleSpecificationArgs>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localeSpecification = mapped
    }

    /**
     * @param value
     */
    @JvmName("ustdrwexhfchnxxa")
    public suspend fun timeouts(`value`: V2modelsBotVersionTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nwixtxjmialidblj")
    public suspend fun timeouts(argument: suspend V2modelsBotVersionTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsBotVersionTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): V2modelsBotVersionArgs = V2modelsBotVersionArgs(
        botId = botId,
        botVersion = botVersion,
        description = description,
        localeSpecification = localeSpecification,
        timeouts = timeouts,
    )
}
